/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.helper.VecHelper;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class RunicAltarBlockEntityRenderer implements class_827<RunicAltarBlockEntity> {
	private final class_630 spinningCube;
	private static final class_2960 cubeTex = prefix("textures/block/runic_altar_cube.png");

	public RunicAltarBlockEntityRenderer(class_5614.class_5615 manager) {
		var mesh = new class_5609();
		// todo 1.17 this doesn't properly map the full texture onto the cube. Needs more param fiddling.
		mesh.method_32111().method_32117("cube", class_5606.method_32108().method_32097(0, 0, 0, 1, 1, 1), class_5603.field_27701);
		spinningCube = class_5607.method_32110(mesh, 16, 16).method_32109();
	}

	@Override
	public void render(@NotNull RunicAltarBlockEntity altar, float partticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();

		int items = 0;
		for (int i = 0; i < altar.inventorySize(); i++) {
			if (altar.getItemHandler().method_5438(i).method_7960()) {
				break;
			} else {
				items++;
			}
		}
		float[] angles = new float[altar.inventorySize()];

		float anglePer = 360F / items;
		float totalAngle = 0F;
		for (int i = 0; i < angles.length; i++) {
			angles[i] = totalAngle += anglePer;
		}

		double time = ClientTickHandler.ticksInGame + partticks;

		for (int i = 0; i < altar.inventorySize(); i++) {
			ms.method_22903();
			ms.method_46416(0.5F, 1.25F, 0.5F);
			ms.method_22907(VecHelper.rotateY(angles[i] + (float) time));
			ms.method_46416(1.125F, 0F, 0.25F);
			ms.method_22907(VecHelper.rotateY(90F));
			ms.method_22904(0D, 0.075 * Math.sin((time + i * 10) / 5D), 0F);
			class_1799 stack = altar.getItemHandler().method_5438(i);
			class_310 mc = class_310.method_1551();
			if (!stack.method_7960()) {
				mc.method_1480().method_23178(stack, class_811.field_4318,
						light, overlay, ms, buffers, altar.method_10997(), 0);
			}
			ms.method_22909();
		}

		ms.method_22903();
		ms.method_46416(0.5F, 0.5F, 0.5F);
		renderSpinningCubes(ms, buffers, overlay, 2, 15);
		ms.method_22909();

		ms.method_46416(0F, 0.2F, 0F);
		float scale = altar.getTargetMana() == 0 ? 0 : (float) altar.getCurrentMana() / (float) altar.getTargetMana() / 75F;

		if (scale != 0) {
			int seed = altar.method_11016().method_10263() ^ altar.method_11016().method_10264() ^ altar.method_11016().method_10260();
			ms.method_46416(0.5F, 0.7F, 0.5F);
			RenderHelper.renderStar(ms, buffers, 0x00E4D7, scale, scale, scale, seed);
		}

		ms.method_22909();
	}

	private void renderSpinningCubes(class_4587 ms, class_4597 buffers, int overlay, int cubes, int iters) {
		for (int curIter = iters; curIter > 0; curIter--) {
			final float modifier = 6F;
			final float rotationModifier = 0.2F;
			final float radiusBase = 0.35F;
			final float radiusMod = 0.05F;

			double ticks = ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks - 1.3 * (iters - curIter);
			float offsetPerCube = 360 / cubes;

			ms.method_22903();
			ms.method_46416(-0.025F, 0.85F, -0.025F);
			for (int i = 0; i < cubes; i++) {
				float offset = offsetPerCube * i;
				float deg = (int) (ticks / rotationModifier % 360F + offset);
				float rad = VecHelper.toRadians(deg);
				float radiusX = (float) (radiusBase + radiusMod * Math.sin(ticks / modifier));
				float radiusZ = (float) (radiusBase + radiusMod * Math.cos(ticks / modifier));
				float x = (float) (radiusX * Math.cos(rad));
				float z = (float) (radiusZ * Math.sin(rad));
				float y = (float) Math.cos((ticks + 50 * i) / 5F) / 10F;

				ms.method_22903();
				ms.method_46416(x, y, z);
				float xRotate = (float) Math.sin(ticks * rotationModifier) / 2F;
				float yRotate = (float) Math.max(0.6F, Math.sin(ticks * 0.1F) / 2F + 0.5F);
				float zRotate = (float) Math.cos(ticks * rotationModifier) / 2F;

				ms.method_22907(new Quaternionf().rotateAxis(rad, xRotate, yRotate, zRotate));
				float alpha = 1;
				if (curIter < iters) {
					alpha = (float) curIter / (float) iters * 0.4F;
				}

				class_4588 buffer = buffers.getBuffer(curIter < iters ? class_1921.method_23689(cubeTex) : class_1921.method_23572(cubeTex));
				spinningCube.method_22699(ms, buffer, 0xF000F0, overlay, 1, 1, 1, alpha);

				ms.method_22909();
			}
			ms.method_22909();
		}
	}
}
