/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.block.block_entity.BreweryBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class BotanicalBreweryModel extends class_3879 {
	private static final class_2960 TEXTURE = new class_2960(ResourcesLib.MODEL_BREWERY);
	final class_630 top;
	final class_630 pole;
	final class_630 bottom;

	final class_630 plate;

	public BotanicalBreweryModel(class_630 root) {
		super(class_1921::method_23572);

		top = root.method_32086("top");
		pole = root.method_32086("pole");
		bottom = root.method_32086("bottom");
		plate = root.method_32086("plate");
	}

	public static class_5609 createMesh() {
		var mesh = new class_5609();
		var root = mesh.method_32111();
		root.method_32117("top", class_5606.method_32108().method_32101(8, 0)
				.method_32097(-2.0F, -7.0F, -2.0F, 4, 1, 4),
				class_5603.method_32090(0.0F, 16.0F, 0.0F));
		root.method_32117("pole", class_5606.method_32108()
				.method_32097(-1.0F, -6.0F, -1.0F, 2, 10, 2),
				class_5603.method_32090(0.0F, 16.0F, 0.0F));
		root.method_32117("bottom", class_5606.method_32108().method_32101(8, 5)
				.method_32097(-2.0F, 4.0F, -2.0F, 4, 1, 4),
				class_5603.method_32090(0.0F, 16.0F, 0.0F));
		root.method_32117("plate", class_5606.method_32108().method_32101(8, 5)
				.method_32097(5.0F, 0.0F, -2.0F, 4, 1, 4),
				class_5603.method_32090(0.0F, 17.0F, 0.0F));
		return mesh;
	}

	public void render(@Nullable BreweryBlockEntity brewery, double time, class_4587 ms, class_4597 buffers, int light, int overlay) {
		float offset = (float) Math.sin(time / 40) * 0.1F + 0.05F;
		boolean hasTile = brewery != null;
		int plates = hasTile ? brewery.inventorySize() - 1 : 7;
		float deg = (float) time / 16F;
		float polerot = -deg * 25F;

		ms.method_46416(0F, offset, 0F);
		ms.method_22907(VecHelper.rotateY(polerot));
		if (hasTile && !brewery.getItemHandler().method_5438(0).method_7960()) {
			ms.method_22903();
			ms.method_22907(VecHelper.rotateX(180));
			ms.method_46416(0, -0.45F, 0);
			renderItemStack(brewery.getItemHandler().method_5438(0), ms, buffers, brewery.method_10997(), light, overlay);
			ms.method_22909();
		}

		class_1921 layer = method_23500(TEXTURE);
		pole.method_22698(ms, buffers.getBuffer(layer), light, overlay);
		top.method_22698(ms, buffers.getBuffer(layer), light, overlay);
		bottom.method_22698(ms, buffers.getBuffer(layer), light, overlay);
		ms.method_22907(VecHelper.rotateY(-polerot));

		float degper = (float) (2F * Math.PI) / plates;
		for (int i = 0; i < plates; i++) {
			plate.field_3675 = deg;
			float offset1 = (float) Math.sin(time / 20 + i * 40F) * 0.2F - 0.2F;
			if (time == -1) {
				offset1 = 0F;
			}

			ms.method_46416(0F, offset1, 0F);
			if (hasTile && !brewery.getItemHandler().method_5438(i + 1).method_7960()) {
				float rot = plate.field_3675 * 180F / (float) Math.PI;
				float transX = 0.3125F;
				float transY = 1.06F;
				float transZ = 0.1245F;
				ms.method_22903();
				ms.method_22907(VecHelper.rotateY(rot));
				ms.method_46416(transX, transY, transZ);
				ms.method_22907(VecHelper.rotateX(-90F));
				ms.method_46416(0.125F, 0.125F, 0);
				renderItemStack(brewery.getItemHandler().method_5438(i + 1), ms, buffers, brewery.method_10997(), light, overlay);
				ms.method_22909();
			}
			plate.method_22698(ms, buffers.getBuffer(layer), light, overlay);
			ms.method_46416(0F, -offset1, 0F);

			deg += degper;
		}
		ms.method_46416(0F, -offset, 0F);
	}

	private void renderItemStack(class_1799 stack, class_4587 ms, class_4597 buffers, @Nullable class_1937 level, int light, int overlay) {
		if (!stack.method_7960()) {
			class_310 mc = class_310.method_1551();
			ms.method_22903();

			float s = 0.25F;
			ms.method_22905(s, s, s);
			mc.method_1480().method_23178(stack, class_811.field_4318,
					light, overlay, ms, buffers, level, 0);
			ms.method_22909();
		}
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {
		throw new UnsupportedOperationException("unimplemented, call using other render method");
	}
}
