/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

/**
 * An armor item that implements this can provide a mana discount for mana tools.
 * Mana tools are the ones on the main toolset (Pick, Shovel, Axe, Sword and Shovel)
 * as well as Rods.
 */
public interface ManaDiscountArmor {

	/**
	 * Gets the mana discount that this piece of armor provides for the specified
	 * tool. This is added together to create the full discount.
	 * Value is to be from 0.0 to 1.0. 0.1 is 10% discount, as an example.
	 * You can also return negative values to make tools cost more.
	 */
	default float getDiscount(class_1799 stack, int slot, class_1657 player, @Nullable class_1799 tool) {
		return 0;
	}
}
