/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.CustomApothecaryColor;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class PetalApothecaryBlockEntity
extends SimpleInventoryBlockEntity
implements PetalApothecary {
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int CRAFT_EFFECT_EVENT = 1;
    private List<class_1799> lastRecipe = null;
    private class_1856 lastReagent = class_1856.field_9017;
    private int recipeKeepTicks = 0;

    public PetalApothecaryBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.ALTAR, pos, state);
    }

    public boolean collideEntityItem(class_1542 item) {
        PetalApothecaryRecipe recipe;
        class_1799 stack = item.method_6983();
        if (this.field_11863.field_9236 || stack.method_7960() || !item.method_5805()) {
            return false;
        }
        if (this.getFluid() == PetalApothecary.State.EMPTY) {
            class_1785 bucketItem;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1785 && XplatAbstractions.INSTANCE.getBucketFluid((class_1755)(bucketItem = (class_1785)class_17922)) == class_3612.field_15910) {
                this.setFluid(PetalApothecary.State.WATER);
                bucketItem.method_7728(null, this.field_11863, stack, this.method_11016().method_10084());
                item.method_6979(new class_1799((class_1935)class_1802.field_8550));
                XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).apothecarySpawned = true;
                return true;
            }
            if (XplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (class_3611)class_3612.field_15910)) {
                this.setFluid(PetalApothecary.State.WATER);
                XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).apothecarySpawned = true;
                return true;
            }
            if (XplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (class_3611)class_3612.field_15908)) {
                this.setFluid(PetalApothecary.State.LAVA);
                XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).apothecarySpawned = true;
                return true;
            }
            return false;
        }
        if (this.getFluid() == PetalApothecary.State.LAVA) {
            item.method_5639(100);
            return true;
        }
        Optional maybeRecipe = this.field_11863.method_8433().method_8132(BotaniaRecipeTypes.PETAL_TYPE, this.getItemHandler(), this.field_11863);
        if (maybeRecipe.isPresent() && (recipe = (PetalApothecaryRecipe)maybeRecipe.get()).getReagent().method_8093(item.method_6983())) {
            this.saveLastRecipe(recipe.getReagent());
            class_1799 output = recipe.method_8116(this.getItemHandler(), this.method_10997().method_30349());
            class_1297 thrower = item.method_24921();
            for (int i = 0; i < this.inventorySize(); ++i) {
                this.getItemHandler().method_5447(i, class_1799.field_8037);
            }
            EntityHelper.shrinkItem(item);
            class_1542 outputItem = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, output);
            XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)outputItem).apothecarySpawned = true;
            if (thrower instanceof class_1657) {
                class_1657 player = (class_1657)thrower;
                player.method_51283((class_1860)recipe, List.of(output));
                output.method_7982(this.field_11863, player, output.method_7947());
            }
            this.field_11863.method_8649((class_1297)outputItem);
            this.setFluid(PetalApothecary.State.EMPTY, false);
            this.field_11863.method_33596(null, class_5712.field_28174, this.method_11016());
            this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 1, 0);
            return true;
        }
        if (!XplatAbstractions.INSTANCE.isFluidContainer(item) && !XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).apothecarySpawned) {
            if (!this.getItemHandler().method_5438(this.inventorySize() - 1).method_7960()) {
                return false;
            }
            if (this.lastReagent.method_8093(item.method_6983())) {
                return false;
            }
            for (int i = 0; i < this.inventorySize(); ++i) {
                if (!this.getItemHandler().method_5438(i).method_7960()) continue;
                this.getItemHandler().method_5447(i, stack.method_7971(1));
                EntityHelper.syncItem(item);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14737, class_3419.field_15245, 0.1f, 10.0f);
                this.field_11863.method_33596(null, class_5712.field_28733, this.method_11016());
                this.clearLastRecipe();
                return true;
            }
        }
        return false;
    }

    @Nullable
    private CustomApothecaryColor getFlowerComponent(class_1799 stack) {
        CustomApothecaryColor c = null;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CustomApothecaryColor) {
            CustomApothecaryColor color;
            c = color = (CustomApothecaryColor)class_17922;
        }
        return c;
    }

    public void saveLastRecipe(class_1856 reagent) {
        class_1799 stack;
        this.lastRecipe = new ArrayList<class_1799>();
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().method_5438(i)).method_7960(); ++i) {
            this.lastRecipe.add(stack.method_7972());
        }
        this.lastReagent = reagent;
        this.recipeKeepTicks = 400;
        this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 0, 400);
    }

    public void clearLastRecipe() {
        this.lastRecipe = null;
        this.lastReagent = class_1856.field_9017;
    }

    public class_1269 trySetLastRecipe(class_1657 player) {
        if (player.method_37908().method_8608()) {
            return class_1269.method_29236((boolean)true);
        }
        boolean success = InventoryHelper.tryToSetLastRecipe(player, this.getItemHandler(), this.lastRecipe, class_3417.field_14737);
        if (success) {
            this.field_11863.method_33596(null, class_5712.field_28733, this.method_11016());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return success ? class_1269.method_29236((boolean)false) : class_1269.field_5811;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (this.getItemHandler().method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private void tickRecipeKeep() {
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.clearLastRecipe();
        }
    }

    public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, PetalApothecaryBlockEntity self) {
        List items = level.method_18467(class_1542.class, new class_238(worldPosition.method_10084()));
        boolean didChange = false;
        for (class_1542 item : items) {
            didChange = self.collideEntityItem(item) || didChange;
        }
        if (didChange) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
        self.tickRecipeKeep();
    }

    public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, PetalApothecaryBlockEntity self) {
        class_1799 stackAt;
        for (int i = 0; i < self.inventorySize() && !(stackAt = self.getItemHandler().method_5438(i)).method_7960(); ++i) {
            if (!(Math.random() >= 0.97)) continue;
            CustomApothecaryColor comp = self.getFlowerComponent(stackAt);
            int color = comp == null ? 0x888888 : comp.getParticleColor(stackAt);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() >= 0.75) {
                level.method_8396(null, worldPosition, class_3417.field_14737, class_3419.field_15245, 0.1f, 10.0f);
            }
            SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
            level.method_8406((class_2394)data, (double)worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)worldPosition.method_10264() + 1.2, (double)worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
        }
        if (self.getFluid() == PetalApothecary.State.LAVA) {
            level.method_8406((class_2394)class_2398.field_11251, (double)worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.method_10264() + 1), (double)worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.05, 0.0);
            if (Math.random() > 0.9) {
                level.method_8406((class_2394)class_2398.field_11239, (double)worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.method_10264() + 1), (double)worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.01, 0.0);
            }
        }
        self.tickRecipeKeep();
    }

    public boolean method_11004(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                if (this.field_11863.field_9236) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_11863.method_8406((class_2394)data, (double)this.field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), BotaniaSounds.altarCraft, class_3419.field_15245, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.method_11004(id, param);
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(16){

            public int method_5444() {
                return 1;
            }
        };
    }

    @Override
    public void setFluid(PetalApothecary.State fluid) {
        this.setFluid(fluid, true);
    }

    public void setFluid(PetalApothecary.State fluid, boolean withVibration) {
        if (withVibration) {
            this.field_11863.method_33596(null, fluid == PetalApothecary.State.EMPTY ? class_5712.field_28167 : class_5712.field_28166, this.method_11016());
        }
        this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(PetalApothecaryBlock.FLUID, (Comparable)((Object)fluid)));
    }

    @Override
    public PetalApothecary.State getFluid() {
        return (PetalApothecary.State)((Object)this.method_11010().method_11654(PetalApothecaryBlock.FLUID));
    }

    public boolean canAddLastRecipe() {
        return this.isEmpty() && this.getFluid() == PetalApothecary.State.WATER;
    }

    public static class Hud {
        public static void render(PetalApothecaryBlockEntity altar, class_332 gui, class_310 mc) {
            int xc = mc.method_22683().method_4486() / 2;
            int yc = mc.method_22683().method_4502() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().method_5438(i).method_7960(); ++i) {
                ++amt;
            }
            if (amt > 0) {
                float anglePer = 360.0f / (float)amt;
                Optional maybeRecipe = altar.field_11863.method_8433().method_8132(BotaniaRecipeTypes.PETAL_TYPE, altar.getItemHandler(), altar.field_11863);
                maybeRecipe.ifPresent(recipe -> {
                    class_1799 reagent;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, xc + radius + 9, yc - 8, 0, 8, 22, 15);
                    class_1799 stack = recipe.method_8116(altar.getItemHandler(), altar.method_10997().method_30349());
                    gui.method_51445(stack, xc + radius + 32, yc - 8);
                    class_1799[] reagents = recipe.getReagent().method_8105();
                    if (reagents.length == 0) {
                        reagent = new class_1799((class_1935)class_1802.field_8077);
                    } else {
                        int idx = (int)(altar.field_11863.method_8510() / 20L % (long)reagents.length);
                        reagent = reagents[idx];
                    }
                    gui.method_51445(reagent, xc + radius + 16, yc + 6);
                    gui.method_51433(mc.field_1772, "+", xc + radius + 14, yc + 10, 0xFFFFFF, false);
                });
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    class_4587 pose = RenderSystem.getModelViewStack();
                    pose.method_22903();
                    pose.method_22904(xPos, yPos, 0.0);
                    RenderSystem.applyModelViewMatrix();
                    gui.method_51445(altar.getItemHandler().method_5438(i), 0, 0);
                    pose.method_22909();
                    RenderSystem.applyModelViewMatrix();
                    angle += anglePer;
                }
            }
            if (altar.recipeKeepTicks > 0 && altar.canAddLastRecipe()) {
                String s = class_1074.method_4662((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                gui.method_51433(mc.field_1772, s, xc - mc.field_1772.method_1727(s) / 2, yc + 10, 0xFFFFFF, false);
                s = class_1074.method_4662((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                gui.method_51433(mc.field_1772, s, xc - mc.field_1772.method_1727(s) / 2, yc + 20, 0xFFFFFF, false);
            }
        }
    }
}

