/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.serverbound;

import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraBladeItem;
import vazkii.botania.network.BotaniaPacket;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class LeftClickPacket implements BotaniaPacket {
	public static final LeftClickPacket INSTANCE = new LeftClickPacket();
	public static final class_2960 ID = prefix("lc");

	@Override
	public void encode(class_2540 buf) {

	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static LeftClickPacket decode(class_2540 buf) {
		return INSTANCE;
	}

	public void handle(MinecraftServer server, class_3222 player) {
		// The swing packet will run on the netty thread immediately,
		// so we need to fetch the attack strength ahead of time
		float scale = player.method_7261(0F);
		server.execute(() -> TerraBladeItem.trySpawnBurst(player, scale));
	}
}
