/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.*;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.mana.DrumBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.block.red_string.RedStringBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7889;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

import static vazkii.botania.common.block.BotaniaBlocks.*;
import static vazkii.botania.common.block.BotaniaFlowerBlocks.*;

public class BlockTagProvider extends class_7889<class_2248> {
	public static final Predicate<class_2248> BOTANIA_BLOCK = b -> LibMisc.MOD_ID.equals(class_7923.field_41175.method_10221(b).method_12836());

	public BlockTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookupProvider) {
		super(packOutput, class_7924.field_41254, lookupProvider, (block) -> block.method_40142().method_40237());
	}

	@Override
	protected void method_10514(class_7225.class_7874 provider) {
		method_46827(class_3481.field_15463).method_46829(BotaniaBlocks.ghostRail);
		method_46827(class_3481.field_15469).method_46830(getModBlocks(b -> b instanceof class_2482));
		method_46827(class_3481.field_15468).method_46830(
				BotaniaBlocks.livingwoodSlab, BotaniaBlocks.livingwoodStrippedSlab, BotaniaBlocks.livingwoodPlankSlab,
				BotaniaBlocks.dreamwoodSlab, BotaniaBlocks.dreamwoodStrippedSlab, BotaniaBlocks.dreamwoodPlankSlab,
				BotaniaBlocks.shimmerwoodPlankSlab);
		method_46827(class_3481.field_15459).method_46830(getModBlocks(b -> b instanceof class_2510));
		method_46827(class_3481.field_15502).method_46830(
				BotaniaBlocks.livingwoodStairs, BotaniaBlocks.livingwoodStrippedStairs, BotaniaBlocks.livingwoodPlankStairs,
				BotaniaBlocks.dreamwoodStairs, BotaniaBlocks.dreamwoodStrippedStairs, BotaniaBlocks.dreamwoodPlankStairs,
				BotaniaBlocks.shimmerwoodPlankStairs);
		method_46827(class_3481.field_15504).method_46830(getModBlocks(b -> b instanceof class_2544));
		method_46827(class_3481.field_16584).method_46830(getModBlocks(b -> b instanceof class_2354));
		method_46827(class_3481.field_17619).method_46830(BotaniaBlocks.livingwoodFence, BotaniaBlocks.dreamwoodFence);
		method_46827(class_3481.field_25147).method_46830(getModBlocks(b -> b instanceof class_2349));
		method_46827(class_3481.field_17753).method_46829(BotaniaBlocks.infrangiblePlatform);
		method_46827(class_3481.field_17754).method_46829(BotaniaBlocks.infrangiblePlatform);

		method_46827(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS).method_46830(
				ColorHelper.supportedColors()
						.map(BotaniaBlocks::getFloatingFlower)
						.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
						.toArray(class_2248[]::new)
		);

		method_46827(BotaniaTags.Blocks.SPECIAL_FLOATING_FLOWERS).method_46830(class_7923.field_41175.method_10220().filter(BOTANIA_BLOCK)
				.filter(b -> b instanceof FloatingSpecialFlowerBlock)
				.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
				.toArray(class_2248[]::new)
		);

		method_46827(BotaniaTags.Blocks.FLOATING_FLOWERS).method_46828(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS)
				.method_46828(BotaniaTags.Blocks.SPECIAL_FLOATING_FLOWERS);

		method_46827(BotaniaTags.Blocks.MYSTICAL_FLOWERS).method_46830(
				ColorHelper.supportedColors()
						.map(BotaniaBlocks::getFlower)
						.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
						.toArray(class_2248[]::new)
		);

		method_46827(BotaniaTags.Blocks.SHIMMERING_MUSHROOMS).method_46830(
				ColorHelper.supportedColors()
						.map(BotaniaBlocks::getMushroom)
						.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
						.toArray(class_2248[]::new)
		);

		method_46827(BotaniaTags.Blocks.SHINY_FLOWERS).method_46830(
				ColorHelper.supportedColors()
						.map(BotaniaBlocks::getShinyFlower)
						.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
						.toArray(class_2248[]::new)
		);

		method_46827(BotaniaTags.Blocks.DOUBLE_MYSTICAL_FLOWERS).method_46830(
				ColorHelper.supportedColors()
						.map(BotaniaBlocks::getDoubleFlower)
						.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
						.toArray(class_2248[]::new)
		);

		method_46827(BotaniaTags.Blocks.MISC_SPECIAL_FLOWERS).method_46830(manastar, pureDaisy, bergamute);
		method_46827(BotaniaTags.Blocks.GENERATING_SPECIAL_FLOWERS).method_46830(
				dandelifeon, endoflame, entropinnyum,
				gourmaryllis, hydroangeas, kekimurus,
				munchdew, narslimmus, rafflowsia, rosaArcana,
				shulkMeNot, spectrolus, thermalily
		);
		method_46827(BotaniaTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS).method_46830(
				agricarnation, agricarnationChibi, bellethorn, bellethornChibi,
				bubbell, bubbellChibi, clayconia, clayconiaChibi,
				daffomill, dreadthorn, exoflame, fallenKanade, heiseiDream,
				hopperhock, hopperhockChibi, hyacidus, jadedAmaranthus,
				jiyuulia, jiyuuliaChibi, labellia, loonium, marimorphosis, marimorphosisChibi,
				medumone, orechid, orechidIgnem, pollidisiac, rannuncarpus, rannuncarpusChibi,
				solegnolia, solegnoliaChibi, spectranthemum, tangleberrie, tangleberrieChibi, tigerseye, vinculotus
		);
		method_46827(BotaniaTags.Blocks.SPECIAL_FLOWERS).method_46828(BotaniaTags.Blocks.MISC_SPECIAL_FLOWERS)
				.method_46828(BotaniaTags.Blocks.GENERATING_SPECIAL_FLOWERS)
				.method_46828(BotaniaTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS);

		method_46827(BotaniaTags.Blocks.MINI_FLOWERS).method_46830(
				getModBlocks(b -> XplatAbstractions.INSTANCE.isSpecialFlowerBlock(b)
						&& class_7923.field_41175.method_10221(b).method_12832().endsWith("_chibi"))
		);

		method_46827(BotaniaTags.Blocks.ENCHANTER_FLOWERS).method_46828(BotaniaTags.Blocks.MYSTICAL_FLOWERS)
				.method_46828(BotaniaTags.Blocks.SHINY_FLOWERS)
				.method_46828(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS);

		// Special flowers intentionally excluded due to unwanted behaviors with tree growth and mod compat.
		method_46827(class_3481.field_20338).method_46828(BotaniaTags.Blocks.DOUBLE_MYSTICAL_FLOWERS);
		method_46827(class_3481.field_15480).method_46828(BotaniaTags.Blocks.MYSTICAL_FLOWERS);

		method_46827(class_3481.field_15490).method_46830(BotaniaBlocks.elfGlass, BotaniaBlocks.manaGlass, BotaniaBlocks.bifrost, BotaniaBlocks.bifrostPerm);
		method_46827(class_3481.field_22275).method_46830(BotaniaBlocks.manasteelBlock, BotaniaBlocks.terrasteelBlock, BotaniaBlocks.elementiumBlock,
				BotaniaBlocks.manaDiamondBlock, BotaniaBlocks.dragonstoneBlock);

		@NotNull
		class_2248[] grassBlockVariants = getModBlocks(b -> b instanceof BotaniaGrassBlock);
		method_46827(class_3481.field_29822).method_46830(grassBlockVariants);
		method_46827(class_3481.field_42607).method_46830(grassBlockVariants);
		method_46827(BotaniaTags.Blocks.BLOCKS_ELEMENTIUM).method_46829(BotaniaBlocks.elementiumBlock);
		method_46827(BotaniaTags.Blocks.BLOCKS_MANASTEEL).method_46829(BotaniaBlocks.manasteelBlock);
		method_46827(BotaniaTags.Blocks.BLOCKS_TERRASTEEL).method_46829(BotaniaBlocks.terrasteelBlock);

		method_46827(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE).method_46830(
				BotaniaBlocks.corporeaBlock, BotaniaBlocks.corporeaBrick, BotaniaBlocks.corporeaBrickSlab, BotaniaBlocks.corporeaBrickStairs,
				BotaniaBlocks.corporeaBrickWall, BotaniaBlocks.corporeaCrystalCube, BotaniaBlocks.corporeaFunnel, BotaniaBlocks.corporeaIndex,
				BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaSlab, BotaniaBlocks.corporeaStairs);

		method_46827(class_3481.field_15466); // We aren't calling vanilla's generation, so need to add a dummy so that using this below doesn't error out.
		method_46827(BotaniaTags.Blocks.TERRAFORMABLE)
				.method_46830(class_2246.field_10115, class_2246.field_10508, class_2246.field_10474, class_2246.field_10277, class_2246.field_10340, class_2246.field_10093, class_2246.field_10346, class_2246.field_10289)
				.method_46830(class_2246.field_10566, class_2246.field_10219, class_2246.field_10253, class_2246.field_10520, class_2246.field_10402)
				.method_46830(class_2246.field_10219, class_2246.field_10255, class_2246.field_10477)
				.method_46828(class_3481.field_15466);
		method_46827(BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST).method_46830(class_2246.field_10327, BotaniaBlocks.manaPylon, BotaniaBlocks.naturaPylon, BotaniaBlocks.gaiaPylon);
		method_46827(BotaniaTags.Blocks.MAGNET_RING_BLACKLIST).method_46830(BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool,
				BotaniaBlocks.fabulousPool, BotaniaBlocks.terraPlate, BotaniaBlocks.runeAltar);
		method_46827(BotaniaTags.Blocks.LAPUTA_IMMOBILE);
		method_46827(BotaniaTags.Blocks.LAPUTA_NO_DOUBLE_BLOCK);

		method_46827(BotaniaTags.Blocks.TERRA_PLATE_BASE).method_46830(BotaniaBlocks.livingrock, BotaniaBlocks.shimmerrock);

		method_46827(class_3481.field_22414).method_46829(BotaniaBlocks.solidVines);

		method_46827(class_3481.field_15471).method_46830(livingwoodPlanks, livingwoodPlanksMossy, livingwoodFramed, livingwoodPatternFramed,
				dreamwoodPlanks, dreamwoodPlanksMossy, dreamwoodFramed, dreamwoodPatternFramed, shimmerwoodPlanks);

		method_46827(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING).method_46830(livingwoodGlimmering, livingwoodLogGlimmering,
				livingwoodStrippedGlimmering, livingwoodLogStrippedGlimmering);
		method_46827(BotaniaTags.Blocks.DREAMWOOD_LOGS_GLIMMERING).method_46830(dreamwoodGlimmering, dreamwoodLogGlimmering,
				dreamwoodStrippedGlimmering, dreamwoodLogStrippedGlimmering);

		method_46827(BotaniaTags.Blocks.LIVINGWOOD_LOGS)
				.method_46830(livingwoodLog, livingwood, livingwoodLogStripped, livingwoodStripped)
				.method_46828(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING);
		method_46827(BotaniaTags.Blocks.DREAMWOOD_LOGS)
				.method_46830(dreamwoodLog, dreamwood, dreamwoodLogStripped, dreamwoodStripped)
				.method_46828(BotaniaTags.Blocks.DREAMWOOD_LOGS_GLIMMERING);
		method_46827(class_3481.field_23210).method_46828(BotaniaTags.Blocks.LIVINGWOOD_LOGS).method_46828(BotaniaTags.Blocks.DREAMWOOD_LOGS);

		method_46827(BotaniaTags.Blocks.GHOST_RAIL_BARRIER).method_46828(BotaniaTags.Blocks.DREAMWOOD_LOGS);

		method_46827(BotaniaTags.Blocks.ENDER_AIR_CONVERTABLE).method_46830(class_2246.field_10340, class_2246.field_28888, class_2246.field_10474, class_2246.field_10508, class_2246.field_10115);
		method_46827(BotaniaTags.Blocks.MARIMORPHOSIS_CONVERTABLE).method_46830(class_2246.field_10340, class_2246.field_28888, class_2246.field_10474, class_2246.field_10508, class_2246.field_10115, class_2246.field_27165);

		method_46827(BotaniaTags.Blocks.WEIGHT_LENS_WHITELIST);

		method_46827(class_3481.field_25739).method_46830(
				BotaniaBlocks.biomeStoneFungal, BotaniaBlocks.biomeStoneFungalSlab, BotaniaBlocks.biomeStoneFungalStairs, BotaniaBlocks.biomeStoneFungalWall,
				BotaniaBlocks.biomeBrickFungal, BotaniaBlocks.biomeBrickFungalSlab, BotaniaBlocks.biomeBrickFungalStairs, BotaniaBlocks.biomeBrickFungalWall,
				BotaniaBlocks.biomeCobblestoneFungal, BotaniaBlocks.biomeCobblestoneFungalSlab, BotaniaBlocks.biomeCobblestoneFungalStairs, BotaniaBlocks.biomeCobblestoneFungalWall,
				BotaniaBlocks.biomeChiseledBrickFungal, fungalAltar);

		method_46827(BotaniaTags.Blocks.HORN_OF_THE_WILD_BREAKABLE)
				.method_46829(class_2246.field_28680)
				.method_35922(new class_2960("biomesoplenty:high_grass"))
				.method_35922(new class_2960("biomesoplenty:high_grass_plant"));

		method_46827(class_3481.field_15503);
		method_46827(BotaniaTags.Blocks.HORN_OF_THE_CANOPY_BREAKABLE).method_46828(class_3481.field_15503);

		method_46827(BotaniaTags.Blocks.HORN_OF_THE_COVERING_BREAKABLE).method_46829(class_2246.field_10477);

		method_46827(class_3481.field_21952);
		method_46827(BotaniaTags.Blocks.UNWANDABLE).method_46828(class_3481.field_21952)
				.method_46830(class_2246.field_10021, class_2246.field_37569, class_2246.field_10597, class_2246.field_10091, class_2246.field_10316, BotaniaBlocks.solidVines);

		method_46827(BotaniaTags.Blocks.PASTURE_SEED_REPLACEABLE).method_46830(class_2246.field_10566, class_2246.field_10219, class_2246.field_10402);

		method_46827(BotaniaTags.Blocks.UNETHICAL_TNT_CHECK).method_35922(new class_2960("ae2:tiny_tnt"));

		method_46827(BotaniaTags.Blocks.SINGLE_ITEM_INSERT).method_35922(new class_2960("quark:crafter"));

		method_46827(class_3481.field_15470)
				.method_46830(ColorHelper.supportedColors()
						.map(BotaniaBlocks::getPottedFlower)
						.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
						.toArray(class_2248[]::new))
				.method_46830(ColorHelper.supportedColors()
						.map(BotaniaBlocks::getPottedShinyFlower)
						.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
						.toArray(class_2248[]::new))
				.method_46830(ColorHelper.supportedColors()
						.map(BotaniaBlocks::getPottedMushroom)
						.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
						.toArray(class_2248[]::new))
				.method_46830(
						// misc
						manastarPotted, pureDaisyPotted, bergamutePotted,
						// generating
						dandelifeonPotted, endoflamePotted, entropinnyumPotted,
						gourmaryllisPotted, hydroangeasPotted, kekimurusPotted,
						munchdewPotted, narslimmusPotted, rafflowsiaPotted, rosaArcanaPotted,
						shulkMeNotPotted, spectrolusPotted, thermalilyPotted,
						// functional
						agricarnationPotted, agricarnationChibiPotted, bellethornPotted, bellethornChibiPotted, bubbellPotted,
						bubbellChibiPotted, clayconiaPotted, clayconiaChibiPotted, daffomillPotted, dreadthornPotted,
						exoflamePotted, fallenKanadePotted, heiseiDreamPotted, hopperhockPotted, hopperhockChibiPotted,
						hyacidusPotted, jadedAmaranthusPotted, jiyuuliaPotted, jiyuuliaChibiPotted, labelliaPotted,
						looniumPotted, marimorphosisPotted, marimorphosisChibiPotted, medumonePotted, orechidPotted,
						orechidIgnemPotted, pollidisiacPotted, rannuncarpusPotted, rannuncarpusChibiPotted, solegnoliaPotted,
						solegnoliaChibiPotted, spectranthemumPotted, tangleberriePotted, tangleberrieChibiPotted,
						tigerseyePotted, vinculotusPotted
				);

		method_46827(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL).method_46830(class_2246.field_28678, class_2246.field_28679);
		method_46827(BotaniaTags.Blocks.AGRICARNATION_GROWTH_CANDIDATE).method_46828(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL);
		method_46827(BotaniaTags.Blocks.AGRICARNATION_GROWTH_EXCLUDED).method_46830(class_2246.field_10559, class_2246.field_10251, class_2246.field_37551);

		registerMiningTags();
	}

	private void registerMiningTags() {
		method_46827(class_3481.field_33714).method_46830(
				getModBlocks(b -> b == cellBlock
						|| class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.PETAL_BLOCK_SUFFIX)
				)
		);
		method_46827(class_3481.field_33716).method_46830(
				getModBlocks(b -> b == enchantedSoil
						|| b instanceof FloatingFlowerBlock || b instanceof BotaniaGrassBlock)
		);
		var pickaxe = Set.of(
				alchemyCatalyst, conjurationCatalyst,
				manasteelBlock, elementiumBlock, terrasteelBlock, manaDiamondBlock, dragonstoneBlock,
				manaGlass, elfGlass, bifrostPerm,
				BotaniaBlocks.managlassPane, BotaniaBlocks.alfglassPane, BotaniaBlocks.bifrostPane,
				runeAltar, brewery, terraPlate, distributor, manaVoid, manaDetector,
				pistonRelay, tinyPlanet, spawnerClaw,
				rfGenerator, prism, pump, sparkChanger, forestEye, enderEye,
				hourglass, starfield, blazeBlock
		);
		method_46827(class_3481.field_33715).method_46830(
				getModBlocks(b -> pickaxe.contains(b)
						|| b instanceof PetalApothecaryBlock
						|| b instanceof PylonBlock
						|| b instanceof ManaPoolBlock
						|| b instanceof RedStringBlock
						|| class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.AZULEJO_PREFIX)
						|| class_7923.field_41175.method_10221(b).method_12832().contains("corporea")
						|| class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.PAVEMENT_SUFFIX)
						|| class_7923.field_41175.method_10221(b).method_12832().contains("_quartz")
						|| (class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.METAMORPHIC_PREFIX)
								&& !(b instanceof class_2544)) // vanilla includes #wall already
						|| (class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.LIVING_ROCK)
								&& !(b instanceof class_2544)) // vanilla includes #wall already
						|| class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.SHIMMERROCK)
				)
		);
		var axe = Set.of(
				alfPortal, turntable, manaBomb, bellows, incensePlate,
				cacophonium, avatar, root, felPumpkin
		);
		method_46827(class_3481.field_33713).method_46830(
				getModBlocks(b -> axe.contains(b)
						|| b instanceof DrumBlock
						|| b instanceof OpenCrateBlock
						|| b instanceof PlatformBlock
						|| b instanceof ManaSpreaderBlock
						|| class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.LIVING_WOOD)
						|| class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.DREAM_WOOD)
						|| class_7923.field_41175.method_10221(b).method_12832().contains(LibBlockNames.SHIMMERWOOD_PLANKS)
				)
		);
	}

	@NotNull
	private class_2248[] getModBlocks(Predicate<class_2248> predicate) {
		return class_7923.field_41175.method_10220().filter(BOTANIA_BLOCK.and(predicate))
				.sorted(Comparator.comparing(class_7923.field_41175::method_10221))
				.toArray(class_2248[]::new);
	}
}
