/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.xplat.BotaniaConfig;

import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class SkyblockSavedData extends class_18 {
	private static final String NAME = "gog_skyblock_islands";

	/** The offset is chosen to put islands under default settings in the center of a chunk region. */
	private static final int OFFSET = 1;

	public final BiMap<IslandPos, UUID> skyblocks;
	private final Spiral spiral;

	public SkyblockSavedData(class_2487 nbt) {
		HashBiMap<IslandPos, UUID> map = HashBiMap.create();
		for (class_2520 inbt : nbt.method_10554("Islands", class_2520.field_33260)) {
			class_2487 tag = (class_2487) inbt;
			map.put(IslandPos.fromTag(tag), tag.method_25926("Player"));
		}
		this.skyblocks = map;
		if (nbt.method_10573("SpiralState", class_2520.field_33261)) {
			this.spiral = Spiral.fromArray(nbt.method_10561("SpiralState"));
		} else {
			this.spiral = new Spiral();
		}
	}

	public static SkyblockSavedData get(class_3218 world) {
		return world.method_17983().method_17924(SkyblockSavedData::new,
				() -> new SkyblockSavedData(new class_2487()), NAME);
	}

	public IslandPos getSpawn() {
		if (skyblocks.containsValue(class_156.field_25140)) {
			return skyblocks.inverse().get(class_156.field_25140);
		}
		IslandPos pos = new IslandPos(OFFSET, OFFSET);
		skyblocks.put(pos, class_156.field_25140);
		method_80();
		return pos;
	}

	public IslandPos create(UUID playerId) {
		int scale = BotaniaConfig.common().gogIslandScaleMultiplier();
		IslandPos islandPos;
		do {
			int[] pos = spiral.next();
			islandPos = new IslandPos(pos[0] * scale + OFFSET, pos[1] * scale + OFFSET);
		} while (skyblocks.containsKey(islandPos));

		skyblocks.put(islandPos, playerId);
		method_80();
		return islandPos;
	}

	@NotNull
	@Override
	public class_2487 method_75(@NotNull class_2487 nbt) {
		class_2499 list = new class_2499();
		for (Map.Entry<IslandPos, UUID> entry : skyblocks.entrySet()) {
			class_2487 entryTag = entry.getKey().toTag();
			entryTag.method_25927("Player", entry.getValue());
			list.add(entryTag);
		}
		nbt.method_10539("SpiralState", spiral.toIntArray());
		nbt.method_10566("Islands", list);
		return nbt;
	}

	// Adapted from https://stackoverflow.com/questions/398299/looping-in-a-spiral
	private static class Spiral {
		private int x = 0;
		private int y = 0;
		private int dx = 0;
		private int dy = -1;

		Spiral() {}

		Spiral(int x, int y, int dx, int dy) {
			this.x = x;
			this.y = y;
			this.dx = dx;
			this.dy = dy;
		}

		int[] next() {
			if (x == y || x < 0 && x == -y || x > 0 && x == 1 - y) {
				int t = dx;
				dx = -dy;
				dy = t;
			}
			x += dx;
			y += dy;
			return new int[] { x, y };
		}

		int[] toIntArray() {
			return new int[] { x, y, dx, dy };
		}

		static Spiral fromArray(int[] ints) {
			return new Spiral(ints[0], ints[1], ints[2], ints[3]);
		}
	}
}
