/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.List;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.brew.IncenseStickItem;

public class IncensePlateBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements class_1278 {
    private static final String TAG_TIME_LEFT = "timeLeft";
    private static final String TAG_BURNING = "burning";
    private static final int RANGE = 32;
    private int timeLeft = 0;
    public boolean burning = false;
    public int comparatorOutput = 0;

    public IncensePlateBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.INCENSE_PLATE, pos, state);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, IncensePlateBlockEntity self) {
        class_1799 stack = self.getItemHandler().method_5438(0);
        if (!stack.method_7960() && self.burning) {
            if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && self.timeLeft > 1) {
                self.timeLeft = 1;
                self.spawnSmokeParticles();
            }
            Brew brew = ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack);
            class_1293 effect = brew.getPotionEffects(stack).get(0);
            if (self.timeLeft > 0) {
                --self.timeLeft;
                if (!level.field_9236) {
                    List players = level.method_18467(class_1657.class, new class_238((double)worldPosition.method_10263() + 0.5 - 32.0, (double)worldPosition.method_10264() + 0.5 - 32.0, (double)worldPosition.method_10260() + 0.5 - 32.0, (double)worldPosition.method_10263() + 0.5 + 32.0, (double)worldPosition.method_10264() + 0.5 + 32.0, (double)worldPosition.method_10260() + 0.5 + 32.0));
                    for (class_1657 player : players) {
                        boolean nightVision;
                        class_1293 currentEffect = player.method_6112(effect.method_5579());
                        boolean bl = nightVision = effect.method_5579() == class_1294.field_5925;
                        if (currentEffect != null && currentEffect.method_5584() >= (nightVision ? 205 : 3)) continue;
                        class_1293 applyEffect = new class_1293(effect.method_5579(), nightVision ? 285 : 80, effect.method_5578(), true, true);
                        player.method_6092(applyEffect);
                    }
                    if (level.field_9229.method_43048(20) == 0) {
                        level.method_8396(null, worldPosition, class_3417.field_14993, class_3419.field_15245, 0.1f, 1.0f);
                    }
                } else {
                    double x = (double)worldPosition.method_10263() + 0.5;
                    double y = (double)worldPosition.method_10264() + 0.5;
                    double z = (double)worldPosition.method_10260() + 0.5;
                    int color = brew.getColor(stack);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    WispParticleData data1 = WispParticleData.wisp(0.05f + (float)Math.random() * 0.02f, r, g, b);
                    level.method_8406((class_2394)data1, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, (double)(0.005f - (float)Math.random() * 0.01f), (double)(0.01f + (float)Math.random() * 0.005f), (double)(0.005f - (float)Math.random() * 0.01f));
                    WispParticleData data = WispParticleData.wisp(0.05f + (float)Math.random() * 0.02f, 0.2f, 0.2f, 0.2f);
                    level.method_8406((class_2394)data, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, (double)(0.005f - (float)Math.random() * 0.01f), (double)(0.01f + (float)Math.random() * 0.001f), (double)(0.005f - (float)Math.random() * 0.01f));
                }
            } else {
                self.getItemHandler().method_5447(0, class_1799.field_8037);
                self.burning = false;
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            }
        } else {
            self.timeLeft = 0;
        }
        int newComparator = 0;
        if (!stack.method_7960()) {
            newComparator = 1;
        }
        if (self.burning) {
            newComparator = 2;
        }
        if (self.comparatorOutput != newComparator) {
            self.comparatorOutput = newComparator;
            level.method_8455(worldPosition, state.method_26204());
        }
    }

    public void spawnSmokeParticles() {
        class_5819 random = this.field_11863.method_8409();
        for (int i = 0; i < 4; ++i) {
            this.field_11863.method_8406((class_2394)class_2398.field_11251, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 2.0 * (double)(random.method_43056() ? 1 : -1), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 2.0 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.05, 0.0);
        }
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_15222, class_3419.field_15245, 0.1f, 1.0f);
    }

    public void ignite() {
        class_1799 stack = this.getItemHandler().method_5438(0);
        if (stack.method_7960() || this.burning) {
            return;
        }
        if (((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            this.spawnSmokeParticles();
            return;
        }
        this.burning = true;
        Brew brew = ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack);
        this.timeLeft = brew.getPotionEffects(stack).get(0).method_5584() * 60;
        this.field_11863.method_8396(null, this.method_11016(), BotaniaSounds.incensePlateIgnite, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Override
    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        tag.method_10569(TAG_TIME_LEFT, this.timeLeft);
        tag.method_10556(TAG_BURNING, this.burning);
    }

    @Override
    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        this.timeLeft = tag.method_10550(TAG_TIME_LEFT);
        this.burning = tag.method_10577(TAG_BURNING);
    }

    public boolean acceptsItem(class_1799 stack) {
        return !stack.method_7960() && stack.method_31574(BotaniaItems.incenseStick) && ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack) != BotaniaBrews.fallbackBrew;
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(1){

            public boolean method_5437(int index, class_1799 stack) {
                return IncensePlateBlockEntity.this.acceptsItem(stack);
            }
        };
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean method_5493(int index, @NotNull class_1799 stack, @Nullable class_2350 direction) {
        return false;
    }
}

