/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric.integration.emi;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.MarimorphosisRecipe;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.fabric.integration.emi.AncientWillEmiRecipe;
import vazkii.botania.fabric.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.fabric.integration.emi.BotanicalBreweryEmiRecipe;
import vazkii.botania.fabric.integration.emi.CompositeLensEmiRecipe;
import vazkii.botania.fabric.integration.emi.ElvenTradeEmiRecipe;
import vazkii.botania.fabric.integration.emi.ManaInfusionEmiRecipe;
import vazkii.botania.fabric.integration.emi.MarimorphosisEmiRecipe;
import vazkii.botania.fabric.integration.emi.OrechidEmiRecipe;
import vazkii.botania.fabric.integration.emi.PetalApothecaryEmiRecipe;
import vazkii.botania.fabric.integration.emi.PureDaisyEmiRecipe;
import vazkii.botania.fabric.integration.emi.RunicAltarEmiRecipe;
import vazkii.botania.fabric.integration.emi.TerrestrialAgglomerationEmiRecipe;

public class BotaniaEmiPlugin
implements EmiPlugin {
    private static final Comparator<EmiRecipe> BY_ID = Comparator.comparing(EmiRecipe::getId);
    private static final Comparator<EmiRecipe> BY_GROUP = Comparator.comparing(emiRecipe -> {
        String string;
        if (emiRecipe instanceof BotaniaEmiRecipe) {
            BotaniaEmiRecipe ber = (BotaniaEmiRecipe)emiRecipe;
            string = ber.getGroup();
        } else {
            string = "";
        }
        return string;
    });
    private static final Comparator<EmiRecipe> BY_CATALYST = Comparator.comparing(emiRecipe -> emiRecipe.getCatalysts().stream().flatMap(emiIngredient -> emiIngredient.getEmiStacks().stream()).map(emiStack -> emiStack.getId().toString()).filter(StringUtils::isNotEmpty).findFirst().orElse(""));
    private static final Comparator<EmiRecipe> BY_WEIGHT = Comparator.comparing(emiRecipe -> {
        Integer n;
        if (emiRecipe instanceof OrechidEmiRecipe) {
            OrechidEmiRecipe orechidEmiRecipe = (OrechidEmiRecipe)emiRecipe;
            n = orechidEmiRecipe.getWeight();
        } else {
            n = 0;
        }
        return n;
    }).reversed();
    private static final Comparator<EmiRecipe> ORECHID_COMPARATOR = BY_WEIGHT.thenComparing(BY_ID);
    public static final EmiRecipeCategory PETAL_APOTHECARY = BotaniaEmiPlugin.createCategory("petal_apothecary", (EmiRenderable)EmiStack.of((class_1935)BotaniaBlocks.defaultAltar), BY_ID);
    public static final EmiRecipeCategory MANA_INFUSION = BotaniaEmiPlugin.createCategory("mana_infusion", (EmiRenderable)EmiStack.of((class_1935)BotaniaBlocks.manaPool), BY_CATALYST.thenComparing(BY_GROUP).thenComparing(BY_ID));
    public static final EmiRecipeCategory RUNIC_ALTAR = BotaniaEmiPlugin.createCategory("runic_altar", (EmiRenderable)EmiStack.of((class_1935)BotaniaBlocks.runeAltar), BY_ID);
    public static final EmiRecipeCategory TERRESTRIAL_AGGLOMERATION = BotaniaEmiPlugin.createCategory("terrestrial_agglomeration", (EmiRenderable)EmiStack.of((class_1935)BotaniaBlocks.terraPlate), BY_ID);
    public static final EmiRecipeCategory ELVEN_TRADE = BotaniaEmiPlugin.createCategory("elven_trade", (EmiRenderable)EmiStack.of((class_1935)BotaniaBlocks.alfPortal), BY_ID);
    public static final EmiRecipeCategory BOTANICAL_BREWERY = BotaniaEmiPlugin.createCategory("botanical_brewery", (EmiRenderable)EmiStack.of((class_1935)BotaniaBlocks.brewery), BY_ID);
    public static final EmiRecipeCategory PURE_DAISY = BotaniaEmiPlugin.createCategory("pure_daisy", (EmiRenderable)EmiStack.of((class_1935)BotaniaFlowerBlocks.pureDaisy), BY_ID);
    public static final EmiRecipeCategory ORECHID = BotaniaEmiPlugin.createCategory("orechid", (EmiRenderable)EmiStack.of((class_1935)BotaniaFlowerBlocks.orechid), ORECHID_COMPARATOR);
    public static final EmiRecipeCategory ORECHID_IGNEM = BotaniaEmiPlugin.createCategory("orechid_ignem", (EmiRenderable)EmiStack.of((class_1935)BotaniaFlowerBlocks.orechidIgnem), ORECHID_COMPARATOR);
    public static final EmiRecipeCategory MARIMORPHOSIS = BotaniaEmiPlugin.createCategory("marimorphosis", (EmiRenderable)EmiStack.of((class_1935)BotaniaFlowerBlocks.marimorphosis), ORECHID_COMPARATOR);
    private static final Supplier<class_1799> HOVERED_STACK_GETTER = () -> {
        class_1799 stack;
        EmiIngredient ingr = EmiApi.getHoveredStack((boolean)true).getStack();
        if (ingr.getEmiStacks().size() > 0 && !(stack = ((EmiStack)ingr.getEmiStacks().get(0)).getItemStack()).method_7960()) {
            return stack;
        }
        return class_1799.field_8037;
    };

    private static EmiRecipeCategory createCategory(String idPath, EmiRenderable icon, Comparator<EmiRecipe> comp) {
        return new EmiRecipeCategory(ResourceLocationHelper.prefix(idPath), icon, icon, comp);
    }

    public void register(EmiRegistry registry) {
        if (!CorporeaInputHandler.hoveredStackGetters.contains(HOVERED_STACK_GETTER)) {
            CorporeaInputHandler.hoveredStackGetters.add(HOVERED_STACK_GETTER);
        }
        registry.addCategory(PETAL_APOTHECARY);
        registry.addCategory(MANA_INFUSION);
        registry.addCategory(RUNIC_ALTAR);
        registry.addCategory(TERRESTRIAL_AGGLOMERATION);
        registry.addCategory(ELVEN_TRADE);
        registry.addCategory(BOTANICAL_BREWERY);
        registry.addCategory(PURE_DAISY);
        registry.addCategory(ORECHID);
        registry.addCategory(ORECHID_IGNEM);
        registry.addCategory(MARIMORPHOSIS);
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1935)BotaniaItems.craftingHalo));
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1935)BotaniaItems.autocraftingHalo));
        for (class_2248 apothecary : BotaniaBlocks.ALL_APOTHECARIES) {
            registry.addWorkstation(PETAL_APOTHECARY, (EmiIngredient)EmiStack.of((class_1935)apothecary));
        }
        registry.addWorkstation(MANA_INFUSION, (EmiIngredient)EmiStack.of((class_1935)BotaniaBlocks.manaPool));
        registry.addWorkstation(MANA_INFUSION, (EmiIngredient)EmiStack.of((class_1935)BotaniaBlocks.dilutedPool));
        registry.addWorkstation(MANA_INFUSION, (EmiIngredient)EmiStack.of((class_1935)BotaniaBlocks.fabulousPool));
        registry.addWorkstation(RUNIC_ALTAR, (EmiIngredient)EmiStack.of((class_1935)BotaniaBlocks.runeAltar));
        registry.addWorkstation(TERRESTRIAL_AGGLOMERATION, (EmiIngredient)EmiStack.of((class_1935)BotaniaBlocks.terraPlate));
        registry.addWorkstation(ELVEN_TRADE, (EmiIngredient)EmiStack.of((class_1935)BotaniaBlocks.alfPortal));
        registry.addWorkstation(BOTANICAL_BREWERY, (EmiIngredient)EmiStack.of((class_1935)BotaniaBlocks.brewery));
        registry.addWorkstation(PURE_DAISY, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.pureDaisy));
        registry.addWorkstation(PURE_DAISY, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.pureDaisyFloating));
        registry.addWorkstation(ORECHID, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.orechid));
        registry.addWorkstation(ORECHID, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.orechidFloating));
        registry.addWorkstation(ORECHID_IGNEM, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.orechidIgnem));
        registry.addWorkstation(ORECHID_IGNEM, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.orechidIgnemFloating));
        registry.addWorkstation(MARIMORPHOSIS, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.marimorphosis));
        registry.addWorkstation(MARIMORPHOSIS, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.marimorphosisFloating));
        registry.addWorkstation(MARIMORPHOSIS, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.marimorphosisChibi));
        registry.addWorkstation(MARIMORPHOSIS, (EmiIngredient)EmiStack.of((class_1935)BotaniaFlowerBlocks.marimorphosisChibiFloating));
        registry.setDefaultComparison((Object)BotaniaItems.lexicon, Comparison.compareNbt());
        registry.setDefaultComparison((Object)BotaniaItems.brewFlask, Comparison.compareNbt());
        registry.setDefaultComparison((Object)BotaniaItems.brewVial, Comparison.compareNbt());
        registry.setDefaultComparison((Object)BotaniaItems.bloodPendant, Comparison.compareNbt());
        registry.setDefaultComparison((Object)BotaniaItems.incenseStick, Comparison.compareNbt());
        registry.addRecipe((EmiRecipe)new AncientWillEmiRecipe(EmiStack.of((class_1935)BotaniaItems.terrasteelHelm), EmiIngredient.of(List.of(EmiStack.of((class_1935)BotaniaItems.ancientWillAhrim), EmiStack.of((class_1935)BotaniaItems.ancientWillDharok), EmiStack.of((class_1935)BotaniaItems.ancientWillGuthan), EmiStack.of((class_1935)BotaniaItems.ancientWillKaril), EmiStack.of((class_1935)BotaniaItems.ancientWillTorag), EmiStack.of((class_1935)BotaniaItems.ancientWillVerac)))));
        registry.addRecipe((EmiRecipe)new CompositeLensEmiRecipe(StreamSupport.stream(class_7923.field_41178.method_40260(BotaniaTags.Items.LENS).spliterator(), false).map(class_1799::new).filter(s -> !((LensItem)s.method_7909()).isControlLens((class_1799)s)).filter(s -> ((LensItem)s.method_7909()).isCombinable((class_1799)s)).map(EmiStack::of).toList()));
        class_1799 tipped = new class_1799((class_1935)BotaniaItems.terraPick);
        TerraShattererItem.setTipped(tipped);
        registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(List.of(EmiStack.of((class_1935)BotaniaItems.terraPick), EmiStack.of((class_1935)BotaniaItems.elementiumPick)), EmiStack.of((class_1799)tipped), null));
        for (PetalApothecaryRecipe recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.PETAL_TYPE)) {
            registry.addRecipe((EmiRecipe)new PetalApothecaryEmiRecipe(recipe));
        }
        for (ManaInfusionRecipe recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.MANA_INFUSION_TYPE)) {
            registry.addRecipe((EmiRecipe)new ManaInfusionEmiRecipe(recipe));
        }
        for (RunicAltarRecipe recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.RUNE_TYPE)) {
            registry.addRecipe((EmiRecipe)new RunicAltarEmiRecipe(recipe));
        }
        for (TerrestrialAgglomerationRecipe recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.TERRA_PLATE_TYPE)) {
            registry.addRecipe((EmiRecipe)new TerrestrialAgglomerationEmiRecipe(recipe));
        }
        for (ElvenTradeRecipe recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.ELVEN_TRADE_TYPE)) {
            registry.addRecipe((EmiRecipe)new ElvenTradeEmiRecipe(recipe));
        }
        List<class_1799> containers = List.of(BotaniaItems.vial, BotaniaItems.flask, BotaniaItems.incenseStick, BotaniaItems.bloodPendant).stream().map(class_1799::new).toList();
        for (Object recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.BREW_TYPE)) {
            for (class_1799 container : containers) {
                if (recipe.getOutput(container.method_7972()).method_7960()) continue;
                registry.addRecipe((EmiRecipe)new BotanicalBreweryEmiRecipe((BotanicalBreweryRecipe)recipe, container));
            }
        }
        for (Object recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.PURE_DAISY_TYPE)) {
            registry.addRecipe((EmiRecipe)new PureDaisyEmiRecipe((PureDaisyRecipe)recipe));
        }
        EmiStack flower = EmiStack.of((class_1935)BotaniaFlowerBlocks.orechid);
        for (OrechidRecipe recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.ORECHID_TYPE)) {
            registry.addRecipe((EmiRecipe)new OrechidEmiRecipe(ORECHID, recipe, (EmiIngredient)flower));
        }
        flower = EmiStack.of((class_1935)BotaniaFlowerBlocks.orechidIgnem);
        for (OrechidRecipe recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.ORECHID_IGNEM_TYPE)) {
            registry.addRecipe((EmiRecipe)new OrechidEmiRecipe(ORECHID_IGNEM, recipe, (EmiIngredient)flower));
        }
        flower = EmiStack.of((class_1935)BotaniaFlowerBlocks.marimorphosis);
        for (OrechidRecipe recipe : registry.getRecipeManager().method_30027(BotaniaRecipeTypes.MARIMORPHOSIS_TYPE)) {
            registry.addRecipe((EmiRecipe)new MarimorphosisEmiRecipe((MarimorphosisRecipe)recipe, (EmiIngredient)flower));
        }
    }

    public static int rotateXAround(int x, int y, int cx, int cy, double degrees) {
        double rad = Math.toRadians(degrees);
        return (int)(Math.cos(rad) * (double)(x - cx) - Math.sin(rad) * (double)(y - cy) + (double)cx);
    }

    public static int rotateYAround(int x, int y, int cx, int cy, double degrees) {
        double rad = Math.toRadians(degrees);
        return (int)(Math.sin(rad) * (double)(x - cx) - Math.cos(rad) * (double)(y - cy) + (double)cy);
    }
}

