/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric.integration.corporea;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class FabricTransferCorporeaNode
extends AbstractCorporeaNode {
    protected final Storage<ItemVariant> inv;

    public FabricTransferCorporeaNode(class_1937 world, class_2338 pos, Storage<ItemVariant> inv, CorporeaSpark spark) {
        super(world, pos, spark);
        this.inv = inv;
    }

    @Override
    public List<class_1799> countItems(CorporeaRequest request) {
        return this.iterateOverSlots(request, false);
    }

    @Override
    public List<class_1799> extractItems(CorporeaRequest request) {
        return this.iterateOverSlots(request, true);
    }

    protected List<class_1799> iterateOverSlots(CorporeaRequest request, boolean doit) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StorageView storageView : this.inv) {
            if (storageView.isResourceBlank()) continue;
            int count = (int)Math.min(Integer.MAX_VALUE, storageView.getAmount());
            ItemVariant item = (ItemVariant)storageView.getResource();
            class_1799 stack = item.toStack(count);
            if (!request.getMatcher().test(stack)) continue;
            request.trackFound(count);
            int rem = Math.min(count, request.getStillNeeded() == -1 ? count : request.getStillNeeded());
            if (rem <= 0) continue;
            request.trackSatisfied(rem);
            if (doit) {
                try (Transaction trans = Transaction.openOuter();){
                    builder.addAll(FabricTransferCorporeaNode.breakDownBigStack(item.toStack((int)this.inv.extract((Object)item, (long)rem, (TransactionContext)trans))));
                    if (!this.getSpark().isCreative()) {
                        trans.commit();
                    }
                }
                this.getSpark().onItemExtracted(stack);
                request.trackExtracted(rem);
                continue;
            }
            builder.add((Object)item.toStack((int)this.inv.simulateExtract((Object)item, (long)rem, null)));
        }
        return builder.build();
    }
}

