/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.BotaniaDamageTypes;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class RelicImpl
implements Relic {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";
    private final class_1799 stack;
    @Nullable
    private final class_2960 advancementId;

    public RelicImpl(class_1799 stack, @Nullable class_2960 advancementId) {
        this.stack = stack;
        this.advancementId = advancementId;
    }

    @Override
    public void bindToUUID(UUID uuid) {
        ItemNBTHelper.setString(this.stack, TAG_SOULBIND_UUID, uuid.toString());
    }

    @Override
    @Nullable
    public UUID getSoulbindUUID() {
        if (ItemNBTHelper.verifyExistance(this.stack, TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString(this.stack, TAG_SOULBIND_UUID, ""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry(this.stack, TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public class_2960 getAdvancement() {
        return this.advancementId;
    }

    @Override
    public void tickBinding(class_1657 player) {
        if (this.stack.method_7960()) {
            return;
        }
        if (this.getSoulbindUUID() == null) {
            this.bindToUUID(player.method_5667());
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                RelicBindTrigger.INSTANCE.trigger(serverPlayer, this.stack);
            }
        } else if (!this.isRightPlayer(player) && player.field_6012 % 10 == 0 && this.shouldDamageWrongPlayer()) {
            player.method_5643(RelicImpl.damageSource(player.method_37908().method_30349()), 2.0f);
        }
    }

    @Override
    public boolean isRightPlayer(class_1657 player) {
        return player.method_5667().equals(this.getSoulbindUUID());
    }

    private static class_1282 damageSource(class_5455 registryAccess) {
        return BotaniaDamageTypes.Sources.relicDamage(registryAccess);
    }

    public static void addDefaultTooltip(class_1799 stack, List<class_2561> tooltip) {
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null) {
            return;
        }
        if (relic.getSoulbindUUID() == null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"botaniamisc.relicUnbound"));
        } else {
            class_1657 player = ClientProxy.INSTANCE.getClientPlayer();
            if (player == null || !relic.isRightPlayer(player)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"botaniamisc.notYourSagittarius"));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"botaniamisc.relicSoulbound", (Object[])new Object[]{player.method_5477()}));
            }
        }
    }
}

