/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.xplat.XplatAbstractions;

public class BandOfManaItem
extends BaubleItem {
    protected static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";

    public BandOfManaItem(class_1792.class_1793 props) {
        super(props);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    protected static void setMana(class_1799 stack, int mana) {
        if (mana > 0) {
            ItemNBTHelper.setInt(stack, TAG_MANA, mana);
        } else {
            ItemNBTHelper.removeEntry(stack, TAG_MANA);
        }
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int method_31571(class_1799 stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return class_3532.method_15369((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static class ManaItemImpl
    implements ManaItem {
        protected final class_1799 stack;

        public ManaItemImpl(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            return ItemNBTHelper.getInt(this.stack, BandOfManaItem.TAG_MANA, 0) * this.stack.method_7947();
        }

        @Override
        public int getMaxMana() {
            return 500000 * this.stack.method_7947();
        }

        @Override
        public void addMana(int mana) {
            BandOfManaItem.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.method_7947());
        }

        @Override
        public boolean canReceiveManaFromPool(class_2586 pool) {
            return true;
        }

        @Override
        public boolean canReceiveManaFromItem(class_1799 otherStack) {
            return true;
        }

        @Override
        public boolean canExportManaToPool(class_2586 pool) {
            return true;
        }

        @Override
        public boolean canExportManaToItem(class_1799 otherStack) {
            return true;
        }

        @Override
        public boolean isNoExport() {
            return false;
        }
    }
}

