/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.helper.PlayerHelper;

public class LifeAggregatorItem
extends class_1792 {
    private static final String TAG_SPAWNER = "spawner";
    private static final String TAG_SPAWN_DATA = "SpawnData";
    private static final String TAG_ID = "id";

    public LifeAggregatorItem(class_1792.class_1793 props) {
        super(props);
    }

    @Nullable
    private static class_2960 getEntityId(class_1799 stack) {
        class_2487 tag = stack.method_7941(TAG_SPAWNER);
        if (tag != null && tag.method_10545(TAG_SPAWN_DATA)) {
            tag = tag.method_10562(TAG_SPAWN_DATA);
            DataResult spawnData = class_1952.field_34460.parse((DynamicOps)class_2509.field_11560, (Object)tag);
            return spawnData.result().filter(sd -> sd.method_38093().method_10545(TAG_ID)).map(sd -> class_2960.method_12829((String)sd.method_38093().method_10558(TAG_ID))).orElse(null);
        }
        return null;
    }

    public static boolean hasData(class_1799 stack) {
        return LifeAggregatorItem.getEntityId(stack) != null;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> infoList, class_1836 flags) {
        class_2960 id = LifeAggregatorItem.getEntityId(stack);
        if (id != null) {
            class_7923.field_41177.method_17966(id).ifPresent(type -> infoList.add(type.method_5897()));
        }
    }

    @NotNull
    public class_1269 method_7884(class_1838 ctx) {
        if (LifeAggregatorItem.getEntityId(ctx.method_8041()) == null) {
            return this.captureSpawner(ctx) ? class_1269.method_29236((boolean)ctx.method_8045().method_8608()) : class_1269.field_5811;
        }
        return this.placeSpawner(ctx);
    }

    private class_1269 placeSpawner(class_1838 ctx) {
        class_1799 useStack = new class_1799((class_1935)class_2246.field_10260);
        Pair<class_1269, class_2338> res = PlayerHelper.substituteUseTrackPos(ctx, useStack);
        if (((class_1269)res.getFirst()).method_23665()) {
            class_1937 world = ctx.method_8045();
            class_2338 pos = (class_2338)res.getSecond();
            class_1799 mover = ctx.method_8041();
            if (!world.field_9236) {
                if (ctx.method_8036() != null) {
                    ctx.method_8036().method_20236(ctx.method_20287());
                }
                mover.method_7934(1);
                class_2586 te = world.method_8321(pos);
                if (te instanceof class_2636) {
                    class_2487 spawnerTag = ctx.method_8041().method_7941(TAG_SPAWNER).method_10553();
                    spawnerTag.method_10569("x", pos.method_10263());
                    spawnerTag.method_10569("y", pos.method_10264());
                    spawnerTag.method_10569("z", pos.method_10260());
                    te.method_11014(spawnerTag);
                }
            } else {
                for (int i = 0; i < 100; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle(0.45f + 0.2f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 6);
                    world.method_8406((class_2394)data, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
        return (class_1269)res.getFirst();
    }

    private boolean captureSpawner(class_1838 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_1799 stack = ctx.method_8041();
        class_1657 player = ctx.method_8036();
        if (world.method_8320(pos).method_27852(class_2246.field_10260)) {
            if (!world.field_9236) {
                class_2586 te = world.method_8321(pos);
                stack.method_7948().method_10566(TAG_SPAWNER, (class_2520)te.method_38242());
                world.method_22352(pos, false);
                if (player != null) {
                    player.method_7357().method_7906((class_1792)this, 20);
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        UseItemSuccessTrigger.INSTANCE.trigger(serverPlayer, stack, serverPlayer.method_51469(), pos.method_10263(), pos.method_10264(), pos.method_10260());
                    }
                    player.method_20236(ctx.method_20287());
                }
            } else {
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.1f + 0.05f, red, green, blue);
                    world.method_8406((class_2394)data, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)((float)(Math.random() - 0.5) * 0.15f), (double)((float)(Math.random() - 0.5) * 0.15f), (double)((float)(Math.random() - 0.5) * 0.15f));
                }
            }
            return true;
        }
        return false;
    }
}

