/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

public class HornItem
extends class_1792 {
    public HornItem(class_1792.class_1793 props) {
        super(props);
    }

    @NotNull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)player, (class_1268)hand);
    }

    public void method_7852(class_1937 world, @NotNull class_1309 living, @NotNull class_1799 stack, int time) {
        if (!world.field_9236) {
            if (time != this.method_7881(stack) && time % 5 == 0) {
                HornItem.breakGrass(world, stack, living.method_24515(), living);
            }
            world.method_43128(null, living.method_23317(), living.method_23318(), living.method_23321(), BotaniaSounds.hornDoot, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private static boolean canHarvest(class_1937 level, class_1799 stack, class_2338 pos, @Nullable class_1309 user, HornHarvestable.EnumHornType type) {
        class_2586 be;
        class_2680 state = level.method_8320(pos);
        HornHarvestable harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(level, pos, state, be = level.method_8321(pos));
        if (harvestable != null) {
            return harvestable.canHornHarvest(level, pos, stack, type, user);
        }
        switch (type) {
            default: {
                return state.method_26204() instanceof class_2261 && !state.method_26164(BotaniaTags.Blocks.SPECIAL_FLOWERS);
            }
            case CANOPY: {
                if (state.method_26204() instanceof class_2397 && ((Boolean)state.method_11654((class_2769)class_2397.field_11200)).booleanValue()) {
                    return false;
                }
                return state.method_26164(BotaniaTags.Blocks.HORN_OF_THE_CANOPY_BREAKABLE);
            }
            case COVERING: 
        }
        return state.method_26164(BotaniaTags.Blocks.HORN_OF_THE_COVERING_BREAKABLE);
    }

    public static void breakGrass(class_1937 world, class_1799 stack, class_2338 srcPos, @Nullable class_1309 user) {
        HornHarvestable.EnumHornType type = null;
        if (stack.method_31574(BotaniaItems.grassHorn)) {
            type = HornHarvestable.EnumHornType.WILD;
        } else if (stack.method_31574(BotaniaItems.leavesHorn)) {
            type = HornHarvestable.EnumHornType.CANOPY;
        } else if (stack.method_31574(BotaniaItems.snowHorn)) {
            type = HornHarvestable.EnumHornType.COVERING;
        }
        int range = 12 - type.ordinal() * 3;
        int rangeY = 3 + type.ordinal() * 4;
        ArrayList<class_2338> coords = new ArrayList<class_2338>();
        for (class_2338 pos : class_2338.method_10097((class_2338)srcPos.method_10069(-range, -rangeY, -range), (class_2338)srcPos.method_10069(range, rangeY, range))) {
            if (BergamuteBlockEntity.isBergamuteNearby(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) || !HornItem.canHarvest(world, stack, pos, user, type)) continue;
            coords.add(pos.method_10062());
        }
        Collections.shuffle(coords);
        int count = Math.min(coords.size(), 32 + type.ordinal() * 16);
        for (int i = 0; i < count; ++i) {
            class_2586 be;
            class_2680 state;
            class_2338 currCoords = (class_2338)coords.get(i);
            HornHarvestable harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(world, currCoords, state = world.method_8320(currCoords), be = world.method_8321(currCoords));
            if (harvestable != null && harvestable.hasSpecialHornHarvest(world, currCoords, stack, type, user)) {
                harvestable.harvestByHorn(world, currCoords, stack, type, user);
                continue;
            }
            world.method_22352(currCoords, true);
        }
    }
}

