/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3956;
import net.minecraft.class_4013;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class OrechidManager
implements class_4013 {
    private static final Map<class_3956<? extends OrechidRecipe>, Map<class_2680, List<? extends OrechidRecipe>>> BY_TYPE = new IdentityHashMap<class_3956<? extends OrechidRecipe>, Map<class_2680, List<? extends OrechidRecipe>>>();
    private static final Map<class_3956<? extends OrechidRecipe>, Object2IntOpenHashMap<class_2680>> TOTAL_WEIGHTS_WITHOUT_POSITION = new IdentityHashMap<class_3956<? extends OrechidRecipe>, Object2IntOpenHashMap<class_2680>>();

    public static void registerListener() {
        XplatAbstractions.INSTANCE.registerReloadListener(class_3264.field_14190, ResourceLocationHelper.prefix("orechid"), (class_3302)new OrechidManager());
    }

    public void method_14491(@NotNull class_3300 manager) {
        BY_TYPE.clear();
        TOTAL_WEIGHTS_WITHOUT_POSITION.clear();
    }

    public static <T extends OrechidRecipe> Collection<T> getMatchingRecipes(class_1863 manager, class_3956<T> type, class_2680 state) {
        List list;
        Map byState = BY_TYPE.computeIfAbsent(type, t -> new IdentityHashMap());
        List result = list = byState.computeIfAbsent(state, s -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (OrechidRecipe recipe : manager.method_30027(type)) {
                if (!recipe.getInput().test(state)) continue;
                builder.add((Object)recipe);
            }
            return builder.build();
        });
        return result;
    }

    public static int getTotalDisplayWeightAt(class_1937 level, class_3956<? extends OrechidRecipe> type, class_2680 state, @Nullable class_2338 pos) {
        return pos == null ? OrechidManager.getCachedTotalDisplayWeightWithoutPosition(level, type, state) : OrechidManager.calculateTotalDisplayWeightAtPosition(level, type, state, pos);
    }

    private static int getCachedTotalDisplayWeightWithoutPosition(class_1937 level, class_3956<? extends OrechidRecipe> type, class_2680 state) {
        Object2IntOpenHashMap byState = TOTAL_WEIGHTS_WITHOUT_POSITION.computeIfAbsent(type, t -> new Object2IntOpenHashMap());
        return byState.computeIfAbsent((Object)state, s -> OrechidManager.calculateTotalDisplayWeightAtPosition(level, type, state, null));
    }

    private static int calculateTotalDisplayWeightAtPosition(class_1937 level, class_3956<? extends OrechidRecipe> type, class_2680 state, @Nullable class_2338 pos) {
        Collection<? extends OrechidRecipe> recipeList = OrechidManager.getMatchingRecipes(level.method_8433(), type, state);
        if (recipeList.isEmpty()) {
            return 0;
        }
        ToIntFunction<OrechidRecipe> weightFunction = pos != null ? r -> r.getWeight(level, pos) : OrechidRecipe::getWeight;
        return recipeList.stream().mapToInt(weightFunction).sum();
    }
}

