/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;

public class BlackHoleTalismanExtractRecipe
extends class_1852 {
    public static final NoOpRecipeSerializer<BlackHoleTalismanExtractRecipe> SERIALIZER = new NoOpRecipeSerializer<BlackHoleTalismanExtractRecipe>(BlackHoleTalismanExtractRecipe::new);

    public BlackHoleTalismanExtractRecipe(class_2960 id) {
        super(id, class_7710.field_40251);
    }

    public boolean matches(@NotNull class_8566 inv, @NotNull class_1937 world) {
        boolean foundTalisman = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_31574(BotaniaItems.blackHoleTalisman) && !foundTalisman) {
                int count = BlackHoleTalismanItem.getBlockCount(stack);
                if (count <= 0) {
                    return false;
                }
                foundTalisman = true;
                continue;
            }
            return false;
        }
        return foundTalisman;
    }

    @NotNull
    public class_1799 assemble(@NotNull class_8566 inv, @NotNull class_5455 registries) {
        class_2248 block;
        class_1799 talisman = class_1799.field_8037;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            talisman = stack;
        }
        int count = BlackHoleTalismanItem.getBlockCount(talisman);
        if (count > 0 && (block = BlackHoleTalismanItem.getBlock(talisman)) != null) {
            return new class_1799((class_1935)block, Math.min(64, count));
        }
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return width * height > 0;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(@NotNull class_8566 inv) {
        return RecipeUtils.getRemainingItemsSub((class_1263)inv, s -> {
            if (s.method_31574(BotaniaItems.blackHoleTalisman)) {
                int count = BlackHoleTalismanItem.getBlockCount(s);
                if (count == 0) {
                    return class_1799.field_8037;
                }
                int extract = Math.min(64, count);
                class_1799 copy = s.method_7972();
                copy.method_7939(1);
                BlackHoleTalismanItem.remove(copy, extract);
                ItemNBTHelper.setBoolean(copy, "active", false);
                return copy;
            }
            return null;
        });
    }
}

