/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class SolegnoliaBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final double RANGE = 5.0;
    private static final double RANGE_MINI = 1.0;
    private static final Set<SolegnoliaBlockEntity> existingFlowers = Collections.newSetFromMap(new MapMaker().concurrencyLevel(2).weakKeys().makeMap());

    protected SolegnoliaBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SolegnoliaBlockEntity(class_2338 pos, class_2680 state) {
        this(BotaniaFlowerBlocks.SOLEGNOLIA, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!existingFlowers.contains(this)) {
            existingFlowers.add(this);
        }
    }

    public void method_11012() {
        super.method_11012();
        existingFlowers.remove(this);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public static boolean hasSolegnoliaAround(class_1297 e) {
        for (SolegnoliaBlockEntity flower : existingFlowers) {
            if (flower.redstoneSignal != 0 || flower.method_10997() != e.method_37908() || !(flower.getEffectivePos().method_10268(e.method_23317(), e.method_23318(), e.method_23321()) <= flower.getRange() * flower.getRange())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxMana() {
        return 1;
    }

    @Override
    public int getColor() {
        return 13212749;
    }

    public double getRange() {
        return 5.0;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends SolegnoliaBlockEntity {
        public Mini(class_2338 pos, class_2680 state) {
            super(BotaniaFlowerBlocks.SOLEGNOLIA_CHIBI, pos, state);
        }

        @Override
        public double getRange() {
            return 1.0;
        }
    }
}

