/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4013;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.OpenCrateBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.RecipeManagerAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class CraftyCrateBlockEntity
extends OpenCrateBlockEntity
implements Wandable {
    private static final String TAG_CRAFTING_RESULT = "craft_result";
    private static int recipeEpoch = 0;
    private int signal = 0;
    private class_1799 craftResult = class_1799.field_8037;
    private final Queue<class_2960> lastRecipes = new ArrayDeque<class_2960>();
    private boolean dirty;
    private boolean matchFailed;
    private int lastRecipeEpoch = recipeEpoch;

    public static void registerListener() {
        XplatAbstractions.INSTANCE.registerReloadListener(class_3264.field_14190, ResourceLocationHelper.prefix("craft_crate_epoch_counter"), (class_3302)((class_4013)mgr -> ++recipeEpoch));
    }

    public CraftyCrateBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.CRAFT_CRATE, pos, state);
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(9){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                return !CraftyCrateBlockEntity.this.isLocked(slot);
            }
        };
    }

    public CraftyCratePattern getPattern() {
        class_2680 state = this.method_11010();
        if (!state.method_27852(BotaniaBlocks.craftCrate)) {
            return CraftyCratePattern.NONE;
        }
        return (CraftyCratePattern)((Object)state.method_11654(BotaniaStateProperties.CRATE_PATTERN));
    }

    private boolean isLocked(int slot) {
        return this.getPattern().openSlots.get(slot) == false;
    }

    @Override
    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        this.craftResult = class_1799.method_7915((class_2487)tag.method_10562(TAG_CRAFTING_RESULT));
    }

    @Override
    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        tag.method_10566(TAG_CRAFTING_RESULT, (class_2520)this.craftResult.method_7953(new class_2487()));
    }

    public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, CraftyCrateBlockEntity self) {
        int newSignal;
        if (recipeEpoch != self.lastRecipeEpoch) {
            self.lastRecipeEpoch = recipeEpoch;
            self.matchFailed = false;
        }
        if (!self.matchFailed && self.canEject() && self.isFull() && self.craft(true)) {
            self.ejectAll();
        }
        for (newSignal = 0; newSignal < 9 && (self.isLocked(newSignal) || !self.getItemHandler().method_5438(newSignal).method_7960()); ++newSignal) {
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.method_8455(worldPosition, state.method_26204());
        }
        if (self.dirty) {
            self.dirty = false;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
    }

    private boolean craft(boolean fullCheck) {
        this.field_11863.method_16107().method_15396("craft");
        if (fullCheck && !this.isFull()) {
            return false;
        }
        class_1715 craft = new class_1715(new class_1703(class_3917.field_17333, -1){

            @NotNull
            public class_1799 method_7601(@NotNull class_1657 player, int i) {
                return class_1799.field_8037;
            }

            public boolean method_7597(@NotNull class_1657 player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < craft.method_5439(); ++i) {
            class_1799 stack = this.getItemHandler().method_5438(i);
            if (stack.method_7960() || this.isLocked(i) || stack.method_31574(BotaniaItems.placeholder)) continue;
            craft.method_5447(i, stack);
        }
        Optional<class_3955> matchingRecipe = this.getMatchingRecipe((class_8566)craft);
        matchingRecipe.ifPresent(arg_0 -> this.lambda$craft$1((class_8566)craft, arg_0));
        if (!matchingRecipe.isPresent()) {
            this.matchFailed = true;
        }
        this.field_11863.method_16107().method_15407();
        return matchingRecipe.isPresent() && !this.craftResult.method_7960();
    }

    private Optional<class_3955> getMatchingRecipe(class_8566 craft) {
        for (class_2960 currentRecipe : this.lastRecipes) {
            class_1860 recipe = ((RecipeManagerAccessor)this.field_11863.method_8433()).botania_getAll(class_3956.field_17545).get(currentRecipe);
            if (!(recipe instanceof class_3955)) continue;
            class_3955 craftingRecipe = (class_3955)recipe;
            if (!recipe.method_8115((class_1263)craft, this.field_11863)) continue;
            return Optional.of(craftingRecipe);
        }
        Optional recipe = this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)craft, this.field_11863);
        if (recipe.isPresent()) {
            if (this.lastRecipes.size() >= 8) {
                this.lastRecipes.remove();
            }
            this.lastRecipes.add(((class_3955)recipe.get()).method_8114());
            return recipe;
        }
        return Optional.empty();
    }

    boolean isFull() {
        for (int i = 0; i < this.getItemHandler().method_5439(); ++i) {
            if (this.isLocked(i) || !this.getItemHandler().method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private void ejectAll() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            class_1799 stack = this.getItemHandler().method_5438(i);
            if (stack.method_7960()) continue;
            this.eject(stack, false);
            this.getItemHandler().method_5447(i, class_1799.field_8037);
        }
        if (!this.craftResult.method_7960()) {
            this.eject(this.craftResult, false);
            this.craftResult = class_1799.field_8037;
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (!this.method_10997().field_9236 && this.canEject()) {
            this.craft(false);
            this.ejectAll();
        }
        return true;
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.dirty = true;
            this.matchFailed = false;
        }
    }

    public int getSignal() {
        return this.signal;
    }

    private /* synthetic */ void lambda$craft$1(class_8566 craft, class_3955 recipe) {
        this.craftResult = recipe.method_8116((class_1263)craft, this.method_10997().method_30349());
        if (this.craftResult.method_7960()) {
            this.matchFailed = true;
            return;
        }
        class_1263 handler = this.getItemHandler();
        class_2371 remainders = recipe.method_8111((class_1263)craft);
        for (int i = 0; i < craft.method_5439(); ++i) {
            class_1799 s = (class_1799)remainders.get(i);
            class_1799 inSlot = handler.method_5438(i);
            if (inSlot.method_7960() && s.method_7960() || !inSlot.method_7960() && inSlot.method_31574(BotaniaItems.placeholder)) continue;
            handler.method_5447(i, s);
        }
    }

    public static class WandHud
    implements WandHUD {
        private final CraftyCrateBlockEntity crate;

        public WandHud(CraftyCrateBlockEntity crate) {
            this.crate = crate;
        }

        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            int width = 52;
            int height = 52;
            int xc = mc.method_22683().method_4486() / 2 + 12;
            int yc = mc.method_22683().method_4502() / 2 - height / 2;
            RenderHelper.renderHUDBox(gui, xc - 4, yc - 4, xc + width + 4, yc + height + 4);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    int xp = xc + j * 18;
                    int yp = yc + i * 18;
                    boolean enabled = true;
                    if (this.crate.getPattern() != CraftyCratePattern.NONE) {
                        enabled = this.crate.getPattern().openSlots.get(index);
                    }
                    gui.method_25294(xp, yp, xp + 16, yp + 16, enabled ? 0x22FFFFFF : 0x22FF0000);
                    class_1799 item = this.crate.getItemHandler().method_5438(index);
                    gui.method_51427(item, xp, yp);
                }
            }
        }
    }
}

