/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.GaiaPylonModel;
import vazkii.botania.client.model.ManaPylonModel;
import vazkii.botania.client.model.NaturaPylonModel;
import vazkii.botania.client.model.PylonModel;
import vazkii.botania.client.render.block_entity.TEISR;
import vazkii.botania.common.block.PylonBlock;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class PylonBlockEntityRenderer
implements class_827<PylonBlockEntity> {
    public static final class_2960 MANA_TEXTURE = new class_2960("botania:textures/model/pylon_mana.png");
    public static final class_2960 NATURA_TEXTURE = new class_2960("botania:textures/model/pylon_natura.png");
    public static final class_2960 GAIA_TEXTURE = new class_2960("botania:textures/model/pylon_gaia.png");
    private final ManaPylonModel manaModel;
    private final NaturaPylonModel naturaModel;
    private final GaiaPylonModel gaiaModel;
    private static PylonBlock.Variant forceVariant = PylonBlock.Variant.MANA;
    private static class_811 forceTransform = class_811.field_4315;

    public PylonBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.manaModel = new ManaPylonModel(ctx.method_32140(BotaniaModelLayers.PYLON_MANA));
        this.naturaModel = new NaturaPylonModel(ctx.method_32140(BotaniaModelLayers.PYLON_NATURA));
        this.gaiaModel = new GaiaPylonModel(ctx.method_32140(BotaniaModelLayers.PYLON_GAIA));
    }

    public void render(@Nullable PylonBlockEntity pylon, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
        class_2960 texture;
        PylonModel model;
        boolean renderingItem = pylon == null;
        boolean direct = renderingItem && (forceTransform == class_811.field_4317 || forceTransform.method_29998());
        PylonBlock.Variant type = renderingItem ? forceVariant : ((PylonBlock)pylon.method_11010().method_26204()).variant;
        class_1921 shaderLayer = switch (type) {
            default -> {
                model = this.manaModel;
                texture = MANA_TEXTURE;
                yield direct ? RenderHelper.MANA_PYLON_GLOW_DIRECT : RenderHelper.MANA_PYLON_GLOW;
            }
            case PylonBlock.Variant.NATURA -> {
                model = this.naturaModel;
                texture = NATURA_TEXTURE;
                yield direct ? RenderHelper.NATURA_PYLON_GLOW_DIRECT : RenderHelper.NATURA_PYLON_GLOW;
            }
            case PylonBlock.Variant.GAIA -> {
                model = this.gaiaModel;
                texture = GAIA_TEXTURE;
                yield direct ? RenderHelper.GAIA_PYLON_GLOW_DIRECT : RenderHelper.GAIA_PYLON_GLOW;
            }
        };
        ms.method_22903();
        float worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0f : (float)new Random(pylon.method_11016().hashCode()).nextInt(360);
        ms.method_22904(0.0, pylon == null ? 1.35 : 1.5, 0.0);
        ms.method_22905(1.0f, -1.0f, -1.0f);
        ms.method_22903();
        ms.method_46416(0.5f, 0.0f, -0.5f);
        if (pylon != null) {
            ms.method_22907(VecHelper.rotateY(worldTime * 1.5f));
        }
        class_1921 layer = class_1921.method_23580((class_2960)texture);
        class_4588 buffer = buffers.getBuffer(layer);
        model.renderRing(ms, buffer, light, overlay);
        if (pylon != null) {
            ms.method_22904(0.0, Math.sin((double)worldTime / 20.0) / 20.0 - 0.025, 0.0);
        }
        ms.method_22909();
        ms.method_22903();
        if (pylon != null) {
            ms.method_22904(0.0, Math.sin((double)worldTime / 20.0) / 17.5, 0.0);
        }
        ms.method_46416(0.5f, 0.0f, -0.5f);
        if (pylon != null) {
            ms.method_22907(VecHelper.rotateY(-worldTime));
        }
        buffer = buffers.getBuffer(shaderLayer);
        model.renderCrystal(ms, buffer, light, overlay);
        ms.method_22909();
        ms.method_22909();
    }

    public static class ItemRenderer
    extends TEISR {
        public ItemRenderer(class_2248 block) {
            super(block);
        }

        @Override
        public void render(class_1799 stack, class_811 type, class_4587 ms, class_4597 buffers, int light, int overlay) {
            class_2248 class_22482 = class_2248.method_9503((class_1792)stack.method_7909());
            if (class_22482 instanceof PylonBlock) {
                PylonBlock pylon = (PylonBlock)class_22482;
                forceVariant = pylon.variant;
                forceTransform = type;
                super.render(stack, type, ms, buffers, light, overlay);
            }
        }
    }
}

