/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client;

import java.util.Locale;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6395;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.BottledManaItem;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.common.item.LifeAggregatorItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.equipment.bauble.RingOfMagnetizationItem;
import vazkii.botania.common.item.equipment.tool.bow.LivingwoodBowItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraTruncatorItem;
import vazkii.botania.common.item.relic.FruitOfGrisaiaItem;
import vazkii.botania.common.item.rod.SkiesRodItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.TriConsumer;

public final class BotaniaItemProperties {
    public static void init(TriConsumer<class_1935, class_2960, class_6395> consumer) {
        consumer.accept((class_1935)BotaniaItems.baubleBox, ResourceLocationHelper.prefix("open"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "open", false) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.blackHoleTalisman, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "active", false) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.manaBottle, ResourceLocationHelper.prefix("swigs_taken"), (stack, world, entity, seed) -> 6 - BottledManaItem.getSwigsLeft(stack));
        class_2960 vuvuzelaId = ResourceLocationHelper.prefix("vuvuzela");
        class_6395 isVuvuzela = (stack, world, entity, seed) -> stack.method_7964().getString().toLowerCase(Locale.ROOT).contains("vuvuzela") ? 1.0f : 0.0f;
        consumer.accept((class_1935)BotaniaItems.grassHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((class_1935)BotaniaItems.leavesHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((class_1935)BotaniaItems.snowHorn, vuvuzelaId, isVuvuzela);
        consumer.accept((class_1935)BotaniaItems.lexicon, ResourceLocationHelper.prefix("elven"), (stack, world, living, seed) -> LexicaBotaniaItem.isElven(stack) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.manaCookie, ResourceLocationHelper.prefix("totalbiscuit"), (stack, world, entity, seed) -> stack.method_7964().getString().toLowerCase(Locale.ROOT).contains("totalbiscuit") ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.slimeBottle, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> stack.method_7985() && stack.method_7969().method_10577("active") ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.spawnerMover, ResourceLocationHelper.prefix("full"), (stack, world, entity, seed) -> LifeAggregatorItem.hasData(stack) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.temperanceStone, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "active", false) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.twigWand, ResourceLocationHelper.prefix("bindmode"), (stack, world, entity, seed) -> WandOfTheForestItem.getBindMode(stack) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.dreamwoodWand, ResourceLocationHelper.prefix("bindmode"), (stack, world, entity, seed) -> WandOfTheForestItem.getBindMode(stack) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.autocraftingHalo, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> ItemNBTHelper.getBoolean(stack, "active", true) ? 1.0f : 0.0f);
        class_2960 poolFullId = ResourceLocationHelper.prefix("full");
        class_6395 poolFull = (stack, world, entity, seed) -> {
            class_2248 block = ((class_1747)stack.method_7909()).method_7711();
            boolean renderFull = ((ManaPoolBlock)block).variant == ManaPoolBlock.Variant.CREATIVE || stack.method_7985() && stack.method_7969().method_10577("RenderFull");
            return renderFull ? 1.0f : 0.0f;
        };
        consumer.accept((class_1935)BotaniaBlocks.manaPool, poolFullId, poolFull);
        consumer.accept((class_1935)BotaniaBlocks.dilutedPool, poolFullId, poolFull);
        consumer.accept((class_1935)BotaniaBlocks.creativePool, poolFullId, poolFull);
        consumer.accept((class_1935)BotaniaBlocks.fabulousPool, poolFullId, poolFull);
        class_6395 brewGetter = (stack, world, entity, seed) -> {
            BaseBrewItem item = (BaseBrewItem)stack.method_7909();
            return item.getSwigs() - item.getSwigsLeft(stack);
        };
        consumer.accept((class_1935)BotaniaItems.brewVial, ResourceLocationHelper.prefix("swigs_taken"), brewGetter);
        consumer.accept((class_1935)BotaniaItems.brewFlask, ResourceLocationHelper.prefix("swigs_taken"), brewGetter);
        class_2960 holidayId = ResourceLocationHelper.prefix("holiday");
        class_6395 holidayGetter = (stack, worldIn, entityIn, seed) -> ClientProxy.jingleTheBells ? 1.0f : 0.0f;
        consumer.accept((class_1935)BotaniaItems.manaweaveHelm, holidayId, holidayGetter);
        consumer.accept((class_1935)BotaniaItems.manaweaveChest, holidayId, holidayGetter);
        consumer.accept((class_1935)BotaniaItems.manaweaveBoots, holidayId, holidayGetter);
        consumer.accept((class_1935)BotaniaItems.manaweaveLegs, holidayId, holidayGetter);
        class_6395 ringOnGetter = (stack, worldIn, entityIn, seed) -> RingOfMagnetizationItem.getCooldown(stack) <= 0 ? 1.0f : 0.0f;
        consumer.accept((class_1935)BotaniaItems.magnetRing, ResourceLocationHelper.prefix("active"), ringOnGetter);
        consumer.accept((class_1935)BotaniaItems.magnetRingGreater, ResourceLocationHelper.prefix("active"), ringOnGetter);
        consumer.accept((class_1935)BotaniaItems.elementiumShears, ResourceLocationHelper.prefix("reddit"), (stack, world, entity, seed) -> stack.method_7964().getString().equalsIgnoreCase("dammit reddit") ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.manasteelSword, ResourceLocationHelper.prefix("elucidator"), (stack, world, entity, seed) -> "the elucidator".equals(stack.method_7964().getString().toLowerCase(Locale.ROOT).trim()) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.terraAxe, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> {
            class_1657 player;
            return !(entity instanceof class_1657) || TerraTruncatorItem.shouldBreak(player = (class_1657)entity) ? 1 : 0;
        });
        consumer.accept((class_1935)BotaniaItems.terraPick, ResourceLocationHelper.prefix("tipped"), (stack, world, entity, seed) -> TerraShattererItem.isTipped(stack) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.terraPick, ResourceLocationHelper.prefix("active"), (stack, world, entity, seed) -> TerraShattererItem.isEnabled(stack) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.infiniteFruit, ResourceLocationHelper.prefix("boot"), (stack, worldIn, entity, seed) -> FruitOfGrisaiaItem.isBoot(stack) ? 1.0f : 0.0f);
        consumer.accept((class_1935)BotaniaItems.tornadoRod, ResourceLocationHelper.prefix("active"), (stack, world, living, seed) -> SkiesRodItem.isFlying(stack) ? 1.0f : 0.0f);
        class_6395 pulling = (stack, worldIn, entity, seed) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f;
        class_6395 pull = (stack, worldIn, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            LivingwoodBowItem item = (LivingwoodBowItem)stack.method_7909();
            return entity.method_6030() != stack ? 0.0f : (float)(stack.method_7935() - entity.method_6014()) * item.chargeVelocityMultiplier() / 20.0f;
        };
        consumer.accept((class_1935)BotaniaItems.livingwoodBow, new class_2960("pulling"), pulling);
        consumer.accept((class_1935)BotaniaItems.livingwoodBow, new class_2960("pull"), pull);
        consumer.accept((class_1935)BotaniaItems.crystalBow, new class_2960("pulling"), pulling);
        consumer.accept((class_1935)BotaniaItems.crystalBow, new class_2960("pull"), pull);
    }

    private BotaniaItemProperties() {
    }
}

