/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.api.block.FloatingFlowerImpl;
import vazkii.botania.api.block.FloatingFlowerProvider;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.red_string.RedStringSpooferBlockEntity;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.lib.BotaniaTags;

public abstract class SpecialFlowerBlockEntity
extends class_2586
implements FloatingFlowerProvider {
    public static final int PODZOL_DELAY = 5;
    public static final int MYCELIUM_DELAY = 10;
    private final FloatingFlower floatingData = new FloatingFlowerImpl(){

        @Override
        public class_1799 getDisplayStack() {
            class_2960 id = class_7923.field_41181.method_10221((Object)SpecialFlowerBlockEntity.this.method_11017());
            return class_7923.field_41178.method_17966(id).map(class_1799::new).orElse(super.getDisplayStack());
        }
    };
    public int ticksExisted = 0;
    public boolean overgrowth = false;
    public boolean overgrowthBoost = false;
    private class_2338 positionOverride;
    private boolean isFloating;
    public static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_FLOATING_DATA = "floating";

    public SpecialFlowerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, SpecialFlowerBlockEntity self) {
        class_2586 tileBelow;
        if (self.isFloating != state.method_26164(BotaniaTags.Blocks.FLOATING_FLOWERS)) {
            BotaniaAPI.LOGGER.error("Special flower changed floating state, this is not supported!", new Throwable());
            boolean bl = self.isFloating = !self.isFloating;
        }
        if ((tileBelow = level.method_8321(worldPosition.method_10074())) instanceof RedStringSpooferBlockEntity) {
            RedStringSpooferBlockEntity relay = (RedStringSpooferBlockEntity)tileBelow;
            class_2338 coords = relay.getBinding();
            if (coords != null) {
                self.positionOverride = coords;
                self.tickFlower();
                return;
            }
            self.positionOverride = null;
        } else {
            self.positionOverride = null;
        }
        boolean special = self.isOnSpecialSoil();
        if (special) {
            self.overgrowth = true;
            if (self.isOvergrowthAffected()) {
                self.tickFlower();
                self.overgrowthBoost = true;
            }
        }
        self.tickFlower();
        self.overgrowth = false;
        self.overgrowthBoost = false;
    }

    @Override
    @Nullable
    public FloatingFlower getFloatingData() {
        if (this.method_11002() && this.isFloating()) {
            return this.floatingData;
        }
        return null;
    }

    public final boolean isFloating() {
        return this.isFloating;
    }

    public final void setFloating(boolean floating) {
        this.isFloating = floating;
    }

    private boolean isOnSpecialSoil() {
        if (this.isFloating()) {
            return false;
        }
        return this.field_11863.method_8320(this.field_11867.method_10074()).method_27852(BotaniaBlocks.enchantedSoil);
    }

    public final class_2338 getEffectivePos() {
        return this.positionOverride != null ? this.positionOverride : this.method_11016();
    }

    protected void tickFlower() {
        ++this.ticksExisted;
    }

    public final void method_11014(class_2487 cmp) {
        super.method_11014(cmp);
        if (cmp.method_10545(TAG_TICKS_EXISTED)) {
            this.ticksExisted = cmp.method_10550(TAG_TICKS_EXISTED);
        }
        if (this.method_11010().method_26204() instanceof FloatingFlowerBlock) {
            this.setFloating(true);
        }
        FloatingFlower.IslandType oldType = this.floatingData.getIslandType();
        this.readFromPacketNBT(cmp);
        if (this.isFloating() && oldType != this.floatingData.getIslandType() && this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 0);
        }
    }

    public final void method_11007(class_2487 cmp) {
        super.method_11007(cmp);
        cmp.method_10569(TAG_TICKS_EXISTED, this.ticksExisted);
        this.writeToPacketNBT(cmp);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.writeToPacketNBT(tag);
        return tag;
    }

    public void writeToPacketNBT(class_2487 cmp) {
        if (this.isFloating()) {
            cmp.method_10566(TAG_FLOATING_DATA, this.floatingData.writeNBT());
        }
    }

    public void readFromPacketNBT(class_2487 cmp) {
        if (cmp.method_10545(TAG_FLOATING_DATA)) {
            this.floatingData.readNBT(cmp.method_10562(TAG_FLOATING_DATA));
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    public void setPlacedBy(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
    }

    @Nullable
    public abstract RadiusDescriptor getRadius();

    @Nullable
    public RadiusDescriptor getSecondaryRadius() {
        return null;
    }

    public boolean isOvergrowthAffected() {
        return true;
    }

    public int getComparatorSignal() {
        return 0;
    }

    public int getModulatedDelay() {
        if (this.isFloating()) {
            FloatingFlower.IslandType type = this.floatingData.getIslandType();
            if (type == FloatingFlower.IslandType.MYCEL) {
                return 10;
            }
            if (type == FloatingFlower.IslandType.PODZOL) {
                return 5;
            }
        } else {
            class_2680 below = this.field_11863.method_8320(this.method_11016().method_10074());
            if (below.method_27852(class_2246.field_10402)) {
                return 10;
            }
            if (below.method_27852(class_2246.field_10520)) {
                return 5;
            }
        }
        return 0;
    }

    @Nullable
    public Object getRenderAttachmentData() {
        if (this.isFloating()) {
            return this.floatingData.getIslandType();
        }
        return null;
    }

    public void emitParticle(class_2394 options, double xOffset, double yOffset, double zOffset, double xSpeed, double ySpeed, double zSpeed) {
        if (!this.field_11863.field_9236) {
            return;
        }
        class_243 offset = this.field_11863.method_8320(this.getEffectivePos()).method_26226((class_1922)this.field_11863, this.getEffectivePos());
        this.field_11863.method_8406(options, (double)this.getEffectivePos().method_10263() + offset.field_1352 + xOffset, (double)this.getEffectivePos().method_10264() + offset.field_1351 + yOffset, (double)this.getEffectivePos().method_10260() + offset.field_1350 + zOffset, xSpeed, ySpeed, zSpeed);
    }
}

