package vazkii.botania.xplat;

import com.google.gson.JsonObject;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.ServiceUtil;
import vazkii.botania.api.block.ExoflameHeatable;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.api.block.HourglassTrigger;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.*;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.common.block.block_entity.red_string.RedStringContainerBlockEntity;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.internal_caps.*;
import vazkii.botania.network.BotaniaPacket;

import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1688;
import net.minecraft.class_1703;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2403;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3611;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7403;

public interface XplatAbstractions {
	// FML/Fabric Loader
	default boolean gogLoaded() {
		return isModLoaded(BotaniaAPI.GOG_MODID);
	}

	// Yes, this forms a loop by default. Each loader overrides their own to break the loop
	default boolean isFabric() {
		return !isForge();
	}

	default boolean isForge() {
		return !isFabric();
	}

	boolean isModLoaded(String modId);
	boolean isDevEnvironment();
	boolean isPhysicalClient();
	String getBotaniaVersion();

	// Capability access (API-facing caps)
	@Nullable
	AvatarWieldable findAvatarWieldable(class_1799 stack);
	@Nullable
	BlockProvider findBlockProvider(class_1799 stack);
	@Nullable
	CoordBoundItem findCoordBoundItem(class_1799 stack);
	@Nullable
	ManaItem findManaItem(class_1799 stack);
	@Nullable
	Relic findRelic(class_1799 stack);
	@Nullable
	ExoflameHeatable findExoflameHeatable(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be);
	@Nullable
	HornHarvestable findHornHarvestable(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be);
	@Nullable
	HourglassTrigger findHourglassTrigger(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be);
	@Nullable
	ManaCollisionGhost findManaGhost(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be);

	@Nullable
	default ManaReceiver findManaReceiver(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
		return findManaReceiver(level, pos, level.method_8320(pos), level.method_8321(pos), direction);
	}

	@Nullable
	ManaReceiver findManaReceiver(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be, @Nullable class_2350 direction);

	@Nullable
	SparkAttachable findSparkAttachable(class_1937 level, class_2338 pos, class_2680 blockState, @Nullable class_2586 be, class_2350 direction);

	@Nullable
	ManaTrigger findManaTrigger(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be);
	@Nullable
	Wandable findWandable(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be);
	boolean isFluidContainer(class_1542 item);
	boolean extractFluidFromItemEntity(class_1542 item, class_3611 fluid);
	boolean extractFluidFromPlayerItem(class_1657 player, class_1268 hand, class_3611 fluid);
	boolean insertFluidIntoPlayerItem(class_1657 player, class_1268 hand, class_3611 fluid);
	boolean hasInventory(class_1937 level, class_2338 pos, class_2350 sideOfPos);
	class_1799 insertToInventory(class_1937 level, class_2338 pos, class_2350 sideOfPos, class_1799 toInsert, boolean simulate);

	// Capability access (internal caps)
	EthicalComponent ethicalComponent(class_1541 tnt);
	SpectralRailComponent ghostRailComponent(class_1688 cart);
	ItemFlagsComponent itemFlagsComponent(class_1542 item);
	KeptItemsComponent keptItemsComponent(class_1657 player, boolean reviveCaps);
	@Nullable
	LooniumComponent looniumComponent(class_1309 entity);
	NarslimmusComponent narslimmusComponent(class_1621 slime);
	TigerseyeComponent tigersEyeComponent(class_1548 creeper);

	// Events
	boolean fireCorporeaRequestEvent(CorporeaRequestMatcher matcher, int itemCount, CorporeaSpark spark, boolean dryRun);
	boolean fireCorporeaIndexRequestEvent(class_3222 player, CorporeaRequestMatcher request, int count, CorporeaSpark spark);
	void fireManaItemEvent(class_1657 player, List<class_1799> toReturn);
	float fireManaDiscountEvent(class_1657 player, float discount, class_1799 tool);
	boolean fireManaProficiencyEvent(class_1657 player, class_1799 tool, boolean proficient);
	void fireElvenPortalUpdateEvent(class_2586 portal, class_238 bounds, boolean open, List<class_1799> stacksInside);
	void fireManaNetworkEvent(ManaReceiver thing, ManaBlockType type, ManaNetworkAction action);

	// Networking
	class_2596<?> toVanillaClientboundPacket(BotaniaPacket packet);
	void sendToPlayer(class_1657 player, BotaniaPacket packet);
	void sendToNear(class_1937 level, class_2338 pos, BotaniaPacket packet);
	void sendToTracking(class_1297 e, BotaniaPacket packet);

	// Registrations
	boolean isSpecialFlowerBlock(class_2248 b);
	class_2356 createSpecialFlowerBlock(class_1291 effect, int effectDuration,
			class_4970.class_2251 props,
			Supplier<class_2591<? extends SpecialFlowerBlockEntity>> beType);
	<T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> func, class_2248... blocks);
	void registerReloadListener(class_3264 type, class_2960 id, class_3302 listener);
	class_1792.class_1793 defaultItemBuilder();

	default class_1792.class_1793 defaultItemBuilderWithCustomDamageOnFabric() {
		return defaultItemBuilder();
	}

	/**
	 * Forge allows items to opt out of craft-repairing using the builder.
	 * Fabric we handle it manually in RepairItemRecipeFabricMixin
	 */
	default class_1792.class_1793 noRepairOnForge(class_1792.class_1793 builder) {
		return builder;
	}

	<T extends class_1703> class_3917<T> createMenuType(TriFunction<Integer, class_1661, class_2540, T> constructor);
	class_2378<Brew> createBrewRegistry();
	@Nullable
	EquipmentHandler tryCreateEquipmentHandler();

	// Misc
	void openMenu(class_3222 player, class_3908 menu, Consumer<class_2540> buf);
	class_1320 getReachDistanceAttribute();
	class_1320 getStepHeightAttribute();
	class_6862<class_2248> getOreTag();
	boolean isInGlassTag(class_2680 state);
	// Forge patches AbstractFurnaceBlockEntity.canBurn to be an instance method, so we gotta abstract it
	boolean canFurnaceBurn(class_2609 furnace, @Nullable class_1860<?> recipe, class_2371<class_1799> items, int maxStackSize);
	// Forge also makes RecipeProvider.saveRecipeAdvancement an instance method >.>
	void saveRecipeAdvancement(class_2403 generator, class_7403 cache, JsonObject json, Path path);
	// Forge patches BucketItem to use a supplier for the fluid, and exposes it, while Fabric needs an accessor
	class_3611 getBucketFluid(class_1755 item);
	int getSmeltingBurnTime(class_1799 stack);
	boolean preventsRemoteMovement(class_1542 entity);
	void addAxeStripping(class_2248 input, class_2248 output);
	int transferEnergyToNeighbors(class_1937 level, class_2338 pos, int energy);

	// Red string container
	boolean isRedStringContainerTarget(class_2586 be);
	RedStringContainerBlockEntity newRedStringContainer(class_2338 pos, class_2680 state);

	XplatAbstractions INSTANCE = ServiceUtil.findService(XplatAbstractions.class, null);
}
