/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.test.block;

import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.ForceRelayBlock.WorldData;
import vazkii.botania.test.TestingUtil;

public class ForceRelayTest {
	@class_6302(method_35936 = "botania:block/piston_relay_basic")
	public void testBasic(class_4516 helper) {
		var initialRelay = new class_2338(4, 2, 2);
		var initialAndesite = new class_2338(4, 4, 5);
		var initialSlimeUnderAndesite = initialAndesite.method_10074();
		var initialDiorite = new class_2338(3, 4, 5);
		var initialSlimeUnderDiorite = initialDiorite.method_10074();

		var data = ForceRelayBlock.WorldData.get(helper.method_35943());
		data.mapping.put(helper.method_36052(initialRelay), helper.method_36052(initialSlimeUnderDiorite));

		helper.method_36041().method_36085(() -> {
			var activateFirstPiston = new class_2338(4, 2, 0);
			helper.method_35984(activateFirstPiston, class_2246.field_10002);
		}).method_36077(4, () -> {
			helper.method_35972(BotaniaBlocks.pistonRelay, initialRelay.method_10072());
			helper.method_35972(class_2246.field_10115, initialAndesite.method_10072());
			helper.method_35972(class_2246.field_10030, initialSlimeUnderAndesite.method_10072());
			helper.method_35972(class_2246.field_10508, initialDiorite.method_10072());
			helper.method_35972(class_2246.field_10030, initialSlimeUnderDiorite.method_10072());
		}).method_36085(() -> {
			var activateSecondPiston = new class_2338(6, 2, 3);
			helper.method_35984(activateSecondPiston, class_2246.field_10002);
		}).method_36077(4, () -> {
			var relayPos = initialRelay.method_10072().method_10067();
			helper.method_35972(BotaniaBlocks.pistonRelay, relayPos);
			// Andesite should not have moved
			helper.method_35972(class_2246.field_10115, initialAndesite.method_10072());
			helper.method_35972(class_2246.field_10030, initialSlimeUnderAndesite.method_10072());
			helper.method_35972(class_2246.field_10508, initialDiorite.method_10072().method_10067());
			helper.method_35972(class_2246.field_10030, initialSlimeUnderDiorite.method_10072().method_10067());

			helper.method_36044(relayPos);
			TestingUtil.assertThat(!data.mapping.containsKey(relayPos), () -> "Removing relay should remove internal mapping");
		}).method_36075();
	}

	@class_6302(method_35936 = "botania:block/piston_relay_immovable")
	public void testImmovable(class_4516 helper) {
		var initialRelay = new class_2338(1, 2, 1);
		var initialCobble = new class_2338(1, 2, 0);

		var data = ForceRelayBlock.WorldData.get(helper.method_35943());
		data.mapping.put(helper.method_36052(initialRelay), helper.method_36052(initialCobble));

		helper.method_36041().method_36085(() -> {
			var lever = new class_2338(2, 2, 2);
			helper.method_36039(lever);
		}).method_36077(4, () -> {
			var relayAfter = new class_2338(0, 2, 1);
			helper.method_35972(BotaniaBlocks.pistonRelay, relayAfter);
			helper.method_35972(class_2246.field_10445, initialCobble);
			TestingUtil.assertEquals(data.mapping.get(helper.method_36052(relayAfter)),
					helper.method_36052(initialCobble),
					() -> "If destination block cannot move, the relay should move but retain " +
							"binding to the destination block's original position");
		}).method_36075();
	}
}
