/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.test;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.item.BotaniaItems;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3965;
import net.minecraft.class_4512;
import net.minecraft.class_4513;
import net.minecraft.class_4516;

public class TestingUtil {
	// Copied from FabricGameTest. Needs to be replaced if we ever run tests on both loaders
	public static final String EMPTY_STRUCTURE = "fabric-gametest-api-v1:empty";

	public static void throwPositionedAssertion(class_4516 helper, class_2338 relativePos, Supplier<String> msg) {
		//A couple of GameTestHelper's assertion errors throw this exception, but it's inconvenient to throw yourself
		throw new class_4513(msg.get(), helper.method_36052(relativePos), relativePos, helper.method_36045());
	}

	public static void assertThat(boolean value, Supplier<String> message) {
		//The same as Preconditions.checkArgument but throws a GameTestAssertException
		if (!value) {
			throw new class_4512(message.get());
		}
	}

	public static void assertAt(class_4516 helper, class_2338 relativePos, boolean value, Supplier<String> message) {
		//The same as Preconditions.checkArgument but throws a GameTestAssertPosException
		if (!value) {
			throwPositionedAssertion(helper, relativePos, message);
		}
	}

	public static void assertEquals(@Nullable Object a, @Nullable Object b) {
		assertEquals(a, b, () -> "Expected " + a + " to equal " + b);
	}

	public static void assertEquals(@Nullable Object a, @Nullable Object b, Supplier<String> message) {
		assertThat(Objects.equals(a, b), message);
	}

	public static void assertEqualsAt(class_4516 helper, class_2338 relativePos, @Nullable Object a, @Nullable Object b) {
		assertEqualsAt(helper, relativePos, a, b, () -> "Expected " + a + " to equal " + b);
	}

	public static void assertEqualsAt(class_4516 helper, class_2338 relativePos, @Nullable Object a, @Nullable Object b, Supplier<String> message) {
		assertAt(helper, relativePos, Objects.equals(a, b), message);
	}

	@SuppressWarnings("unchecked")
	public static <T extends class_2586> T assertBlockEntity(class_4516 helper, class_2338 relativePos, class_2591<T> type) {
		class_2586 be = helper.method_36014(relativePos);

		assertAt(helper, relativePos, be != null, () -> "Expected BlockEntity of type " + class_2378.field_11137.method_10221(type) + " but found no BlockEntity");
		assertAt(helper, relativePos, be.method_11017() == type, () -> "Expected BlockEntity of type " + class_2378.field_11137.method_10221(type) + " but found " + class_2378.field_11137.method_10221(be.method_11017()));

		return (T) be;
	}

	@SuppressWarnings("unchecked")
	public static <T extends class_2586> T assertBlockEntity(class_4516 helper, class_2338 relativePos, Class<T> classs) {
		class_2586 be = helper.method_36014(relativePos);

		assertAt(helper, relativePos, be != null, () -> "Expected BlockEntity of class " + classs.getSimpleName() + " but found no BlockEntity");
		assertAt(helper, relativePos, classs.isAssignableFrom(be.getClass()), () -> "Expected BlockEntity to be an instance of " + classs.getSimpleName() + " but found " + be.getClass().getSimpleName());

		return (T) be;
	}

	public static class_2586 assertAnyBlockEntity(class_4516 helper, class_2338 relativePos) {
		class_2586 be = helper.method_36014(relativePos);
		assertAt(helper, relativePos, be != null, () -> "Expected any BlockEntity but found nothing");
		return be;
	}

	public static void useItemOn(class_4516 helper, class_1657 player, class_1268 hand, class_2338 pos) {
		//Gametest gotcha: You don't have a ClientPlayer or a ServerPlayer, you literally just have a Player.
		//So there's no XxxxPlayerGameMode, which is where Item#useOn(UseOnContext) style interactions typically happen.
		//This is sorta a discount version of ServerPlayerGameMode#useItemOn, no cheat checks or criteria triggers or anything.
		class_2338 absolutePos = helper.method_36052(pos);
		class_3965 result = new class_3965(class_243.method_24953(absolutePos), class_2350.field_11043, absolutePos, true);
		class_1799 stack = player.method_5998(hand);
		class_1838 useOnContext = new class_1838(player, hand, result);
		stack.method_7981(useOnContext);
	}

	public static void bindWithWandOfTheForest(class_4516 helper, class_2338 first, class_2338 second) {
		//Conjure a player with Wand of the Forest
		class_1657 player = helper.method_36021();
		player.method_6122(class_1268.field_5808, new class_1799(BotaniaItems.twigWand));
		player.method_5660(true);

		//Move the player to each destination just to make sure they're in-range
		player.method_33574(class_243.method_24953(first));
		useItemOn(helper, player, class_1268.field_5808, first);
		player.method_33574(class_243.method_24953(second));
		useItemOn(helper, player, class_1268.field_5808, second);
	}
}
