/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.clientbound;

import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.network.BotaniaPacket;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2604;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public record SpawnGaiaGuardianPacket(class_2604 inner, int playerCount, boolean hardMode,
		class_2338 source, UUID bossInfoId) implements BotaniaPacket {

	public static final class_2960 ID = prefix("spg");

	@Override
	public void encode(class_2540 buf) {
		inner().method_11052(buf);
		buf.method_10804(playerCount());
		buf.writeBoolean(hardMode());
		buf.method_10807(source());
		buf.method_10797(bossInfoId());
	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static SpawnGaiaGuardianPacket decode(class_2540 buf) {
		return new SpawnGaiaGuardianPacket(
				new class_2604(buf),
				buf.method_10816(),
				buf.readBoolean(),
				buf.method_10811(),
				buf.method_10790()
		);
	}

	public static class Handler {
		public static void handle(SpawnGaiaGuardianPacket packet) {
			var inner = packet.inner();
			int playerCount = packet.playerCount();
			boolean hardMode = packet.hardMode();
			class_2338 source = packet.source();
			UUID bossInfoUuid = packet.bossInfoId();

			class_310.method_1551().execute(() -> {
				var player = class_310.method_1551().field_1724;
				if (player != null) {
					player.field_3944.method_11112(inner);
					class_1297 e = player.field_6002.method_8469(inner.method_11167());
					if (e instanceof GaiaGuardianEntity dopple) {
						dopple.readSpawnData(playerCount, hardMode, source, bossInfoUuid);
					}
				}
			});
		}
	}
}
