/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.equipment.tool.elementium.ElementiumPickaxeItem;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;

@Mixin(class_52.class)
public class LootTableMixin {
	private static final class_2960 GOG_SEEDS = new class_2960(BotaniaAPI.GOG_MODID, "extra_seeds");

	@Unique
	private boolean callingGogTable;

	@Inject(at = @At("RETURN"), method = "getRandomItemsRaw")
	private void addGogSeeds(class_47 context, Consumer<class_1799> stacksOut, CallbackInfo ci) {
		if (XplatAbstractions.INSTANCE.gogLoaded() && !callingGogTable) {
			callingGogTable = true;
			context.method_22556(GOG_SEEDS).method_320(context, stacksOut);
			callingGogTable = false;
		}
	}

	@ModifyVariable(method = "getRandomItemsRaw", at = @At("HEAD"), argsOnly = true)
	private Consumer<class_1799> filterDisposables(Consumer<class_1799> inner, class_47 context) {
		return stack -> {
			class_1297 e = context.method_296(class_181.field_1226);
			class_1799 tool = context.method_296(class_181.field_1229);
			if (e != null && tool != null) {
				if (ElementiumPickaxeItem.shouldFilterOut(e, tool, stack)) {
					return;
				}
			}

			inner.accept(stack);
		};
	}
}
