package vazkii.botania.mixin;

import com.google.common.collect.ImmutableList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.item.ItemWithBannerPattern;

import java.util.List;
import net.minecraft.class_1726;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2582;
import net.minecraft.class_6880;

@Mixin(class_1726.class)
public class LoomMenuMixin {
	@Inject(at = @At("HEAD"), method = "getSelectablePatterns(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;", cancellable = true)
	private void handleBotaniaPatternItems(class_1799 stack, CallbackInfoReturnable<List<class_6880<class_2582>>> cir) {
		if (stack.method_7909() instanceof ItemWithBannerPattern p) {
			cir.setReturnValue(class_2378.field_39208.method_40266(p.getBannerPattern())
					.map(ImmutableList::copyOf).orElse(ImmutableList.of()));
		}
	}

	// todo also mixin into quickMoveStack to support shift clicking of our banner pattern items
}
