/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4466;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.lib.BotaniaTags;

@Mixin(class_4466.class)
public abstract class BeeMixin extends class_1429 {
	protected BeeMixin(class_1299<? extends class_1429> type, class_1937 worldIn) {
		super(type, worldIn);
	}

	/**
	 * Allows bees to treat special flowers as proper flowers for
	 * pollination despite being excluded from the flower tag.
	 * 
	 * @see PollinateGoalMixin
	 */
	@Inject(
		method = "isFlowerValid", cancellable = true,
		at = @At(value = "FIELD", target = "Lnet/minecraft/world/entity/animal/Bee;level:Lnet/minecraft/world/level/Level;", ordinal = 1)
	)
	private void isSpecialFlower(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
		if (field_6002.method_8477(pos) && field_6002.method_8320(pos).method_26164(BotaniaTags.Blocks.SPECIAL_FLOWERS)) {
			cir.setReturnValue(true);
		}
	}
}
