/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import vazkii.botania.client.gui.ManaBarTooltipComponent;

import java.util.List;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5684;

@Mixin(class_437.class)
public class ScreenFabricMixin {
	@Inject(method = "renderTooltipInternal", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V"), locals = LocalCapture.CAPTURE_FAILHARD)
	private void renderManaBar(class_4587 poseStack, List<class_5684> list, int oldX, int oldY, CallbackInfo ci, int width, int height, int x, int y) {
		for (class_5684 component : list) {
			if (component instanceof ManaBarTooltipComponent manaBar) {
				manaBar.setContext(x, y, width);
			}
		}
	}
}
