/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import net.minecraft.class_1657;
import net.minecraft.class_1715;
import net.minecraft.class_1734;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.item.AssemblyHaloItem;

@Mixin(class_1734.class)
public class ResultSlotFabricMixin {
	@Shadow
	@Final
	private class_1715 craftSlots;

	@Shadow
	@Final
	private class_1657 player;

	@Inject(
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;onCraftedBy(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;I)V"),
		method = "checkTakeAchievements"
	)
	private void onCraft(class_1799 stack, CallbackInfo ci) {
		AssemblyHaloItem.onItemCrafted(player, craftSlots);
	}
}
