/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.block.flower.functional.LooniumBlockEntity;
import vazkii.botania.common.brew.effect.SoulCrossMobEffect;
import vazkii.botania.common.item.AssemblyHaloItem;
import vazkii.botania.common.item.equipment.bauble.SojournersSashItem;
import vazkii.botania.common.item.equipment.tool.elementium.ElementiumAxeItem;
import vazkii.botania.common.item.rod.ShadedMesaRodItem;

@Mixin(class_1309.class)
public abstract class LivingEntityFabricMixin extends class_1297 {

	public LivingEntityFabricMixin(class_1299<?> type, class_1937 world) {
		super(type, world);
	}

	@Shadow
	public abstract class_1799 getItemInHand(class_1268 hand);

	@Shadow
	protected int lastHurtByPlayerTime;

	@Inject(method = "dropAllDeathLoot", at = @At(shift = At.Shift.AFTER, value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;dropFromLootTable(Lnet/minecraft/world/damagesource/DamageSource;Z)V"))
	private void dropEnd(class_1282 source, CallbackInfo ci) {
		var self = (class_1309) (Object) this;
		ElementiumAxeItem.onEntityDrops(lastHurtByPlayerTime > 0, source, self, self::method_5775);
	}

	@Inject(at = @At("HEAD"), cancellable = true, method = "dropFromLootTable")
	private void dropLoonium(class_1282 source, boolean causedByPlayer, CallbackInfo ci) {
		var self = (class_1309) (Object) this;
		LooniumBlockEntity.dropLooniumItems(self, stack -> {
			self.method_5775(stack);
			ci.cancel();
		});
	}

	/**
	 * Applies soul cross effect when being killed
	 */
	@Inject(at = @At("RETURN"), method = "createWitherRose")
	private void healKiller(@Nullable class_1309 adversary, CallbackInfo ci) {
		if (!field_6002.field_9236 && adversary != null) {
			SoulCrossMobEffect.onEntityKill((class_1309) (Object) this, adversary);
		}

	}

	@Inject(at = @At("HEAD"), method = "swing(Lnet/minecraft/world/InteractionHand;Z)V", cancellable = true)
	private void onSwing(class_1268 hand, boolean bl, CallbackInfo ci) {
		class_1799 stack = getItemInHand(hand);
		class_1309 self = (class_1309) (Object) this;
		if (!field_6002.field_9236) {
			if (stack.method_7909() instanceof AssemblyHaloItem halo && halo.onEntitySwing(stack, self)) {
				ci.cancel();
			} else if (stack.method_7909() instanceof ShadedMesaRodItem rod) {
				rod.onEntitySwing(stack, self);
			}
		}
	}

	@Inject(at = @At("RETURN"), method = "jumpFromGround")
	private void onJump(CallbackInfo ci) {
		SojournersSashItem.onPlayerJump((class_1309) (Object) this);
	}
}
