/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.item.FlowerPouchItem;

import java.util.UUID;
import net.minecraft.class_1542;
import net.minecraft.class_1657;

@Mixin(class_1542.class)
public class ItemEntityFabricMixin {
	@Shadow
	private int pickupDelay;

	@Shadow
	private UUID owner;

	@Inject(at = @At("HEAD"), method = "playerTouch", cancellable = true)
	private void onPickup(class_1657 player, CallbackInfo ci) {
		class_1542 self = (class_1542) (Object) this;
		if (!player.field_6002.field_9236 && pickupDelay == 0 && (owner == null || owner.equals(player.method_5667()))
				&& FlowerPouchItem.onPickupItem(self, player)) {
			ci.cancel();
		}
	}

}
