/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.integration.trinkets;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.ResoluteIvyItem;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;

public class TrinketsIntegration extends EquipmentHandler {
	public static void init() {
		TrinketDropCallback.EVENT.register(TrinketsIntegration::keepAccessoryDrops);
	}

	private static TrinketEnums.DropRule keepAccessoryDrops(TrinketEnums.DropRule oldRule,
			class_1799 stack, SlotReference ref, class_1309 livingEntity) {
		//TODO make this less hacky
		if (ResoluteIvyItem.hasIvy(stack)) {
			stack.method_7983(ResoluteIvyItem.TAG_KEEP);
			return TrinketEnums.DropRule.KEEP;
		}
		return oldRule;
	}

	@Override
	protected class_1263 getAllWornItems(class_1309 living) {
		return TrinketsApi.getTrinketComponent(living).map(h -> {
			List<class_1799> list = new ArrayList<>();
			for (var tuple : h.getAllEquipped()) {
				class_1799 stack = tuple.method_15441();
				list.add(stack);
			}

			return new class_1277(list.toArray(new class_1799[0]));
		}).orElseGet(() -> new class_1277(0));
	}

	@Override
	protected class_1799 findItem(class_1792 item, class_1309 living) {
		return TrinketsApi.getTrinketComponent(living).flatMap(h -> {
			var results = h.getEquipped(item);
			if (results.isEmpty()) {
				return Optional.empty();
			} else {
				return Optional.of(results.get(0).method_15441());
			}
		}).orElse(class_1799.field_8037);
	}

	@Override
	protected class_1799 findItem(Predicate<class_1799> pred, class_1309 living) {
		return TrinketsApi.getTrinketComponent(living).flatMap(h -> {
			var results = h.getEquipped(pred);
			if (results.isEmpty()) {
				return Optional.empty();
			} else {
				return Optional.of(results.get(0).method_15441());
			}
		}).orElse(class_1799.field_8037);
	}

	@Override
	public void onInit(class_1792 item) {
		TrinketsApi.registerTrinket(item, WRAPPER);
		Proxy.INSTANCE.runOnClient(() -> () -> TrinketRendererRegistry.registerRenderer(item, new RenderWrapper()));
	}

	public static final Trinket WRAPPER = new Trinket() {
		private BaubleItem getItem(class_1799 stack) {
			return (BaubleItem) stack.method_7909();
		}

		@Override
		public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
			if (!stack.method_7960()) {
				getItem(stack).onWornTick(stack, entity);
			}
		}

		@Override
		public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
			if (!stack.method_7960()) {
				getItem(stack).onEquipped(stack, entity);
			}
		}

		@Override
		public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
			if (!stack.method_7960()) {
				getItem(stack).onUnequipped(stack, entity);
			}
		}

		@Override
		public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
			if (!stack.method_7960()) {
				return getItem(stack).canEquip(stack, entity);
			}
			return false;
		}

		@Override
		public Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
			var ret = Trinket.super.getModifiers(stack, slot, entity, uuid);
			if (!stack.method_7960()) {
				ret.putAll(getItem(stack).getEquippedAttributeModifiers(stack));
			}
			return ret;
		}
	};

	private static class RenderWrapper implements TrinketRenderer {
		@Override
		public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> contextModel,
				class_4587 matrices, class_4597 vertexConsumers, int light, class_1309 livingEntity,
				float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
			BaubleItem item = (BaubleItem) stack.method_7909();
			if (!item.hasRender(stack, livingEntity)) {
				return;
			}

			if (!(contextModel instanceof class_572<?>)) {
				return;
			}

			class_1799 cosmetic = item.getCosmeticItem(stack);
			if (!cosmetic.method_7960()) {
				TrinketRendererRegistry.getRenderer(cosmetic.method_7909())
						.ifPresent(sub -> sub.render(cosmetic, slotReference, contextModel, matrices, vertexConsumers, light, livingEntity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch));
			} else {
				var renderer = AccessoryRenderRegistry.get(stack);
				if (renderer != null) {
					renderer.doRender((class_572<?>) contextModel, stack, livingEntity, matrices, vertexConsumers, light, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
				}
			}
		}
	}
}
