/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.integration.rei;

import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class BotaniaRecipeDisplay<T extends class_1860<class_1263>> implements Display {
	protected final T recipe;
	protected List<EntryIngredient> inputs;
	protected EntryIngredient outputs;

	public BotaniaRecipeDisplay(T recipe) {
		this.recipe = recipe;
		this.inputs = EntryIngredients.ofIngredients(recipe.method_8117());
		this.outputs = EntryIngredients.of(recipe.method_8110());
	}

	@Override
	public @NotNull List<EntryIngredient> getInputEntries() {
		return this.inputs;
	}

	abstract public int getManaCost();

	@Override
	public @NotNull List<EntryIngredient> getOutputEntries() {
		return Collections.singletonList(this.outputs);
	}

	@Override
	public @NotNull Optional<class_2960> getDisplayLocation() {
		return Optional.ofNullable(this.recipe).map(T::method_8114);
	}
}
