/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.integration.rei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.*;
import vazkii.botania.common.item.AncientWillItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.fabric.xplat.FabricXplatImpl;

import java.util.*;
import java.util.Map.Entry;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;

public class BotaniaREIPlugin implements REIClientPlugin {
	public BotaniaREIPlugin() {
		var old = CorporeaInputHandler.hoveredStackGetter;
		CorporeaInputHandler.hoveredStackGetter = () -> {
			var stack = BotaniaREIPlugin.getHoveredREIStack();
			if (!stack.method_7960()) {
				return stack;
			}
			return old.get();
		};
		CorporeaInputHandler.supportedGuiFilter = CorporeaInputHandler.supportedGuiFilter.or(s -> s instanceof DisplayScreen);
	}

	@Override
	public void registerCategories(CategoryRegistry helper) {
		helper.add(List.of(
				new PetalApothecaryREICategory(),
				new PureDaisyREICategory(),
				new ManaPoolREICategory(),
				new RunicAltarREICategory(),
				new ElvenTradeREICategory(),
				new BreweryREICategory(),
				new TerrestrialAgglomerationREICategory(),
				new OrechidREICategory(BotaniaREICategoryIdentifiers.ORECHID, BotaniaFlowerBlocks.orechid),
				new OrechidREICategory(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, BotaniaFlowerBlocks.orechidIgnem),
				new OrechidREICategory(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, BotaniaFlowerBlocks.marimorphosis)
		));

		helper.addWorkstations(BuiltinPlugin.CRAFTING, EntryStacks.of(BotaniaItems.craftingHalo), EntryStacks.of(BotaniaItems.autocraftingHalo));
		Set<class_1935> apothecaries = ImmutableSet.of(
				BotaniaBlocks.defaultAltar,
				BotaniaBlocks.desertAltar,
				BotaniaBlocks.forestAltar,
				BotaniaBlocks.fungalAltar,
				BotaniaBlocks.mesaAltar,
				BotaniaBlocks.mossyAltar,
				BotaniaBlocks.mountainAltar,
				BotaniaBlocks.plainsAltar,
				BotaniaBlocks.swampAltar,
				BotaniaBlocks.taigaAltar);
		for (class_1935 altar : apothecaries) {
			helper.addWorkstations(BotaniaREICategoryIdentifiers.PETAL_APOTHECARY, EntryStacks.of(altar));
		}
		helper.addWorkstations(BotaniaREICategoryIdentifiers.BREWERY, EntryStacks.of(BotaniaBlocks.brewery));
		helper.addWorkstations(BotaniaREICategoryIdentifiers.ELVEN_TRADE, EntryStacks.of(BotaniaBlocks.alfPortal));
		Set<class_1935> manaPools = ImmutableSet.of(
				BotaniaBlocks.manaPool,
				BotaniaBlocks.dilutedPool,
				BotaniaBlocks.fabulousPool
		);
		for (class_1935 pool : manaPools) {
			helper.addWorkstations(BotaniaREICategoryIdentifiers.MANA_INFUSION, EntryStacks.of(pool));
		}
		helper.addWorkstations(BotaniaREICategoryIdentifiers.ORECHID, EntryStacks.of(BotaniaFlowerBlocks.orechid), EntryStacks.of(BotaniaFlowerBlocks.orechidFloating));
		helper.addWorkstations(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, EntryStacks.of(BotaniaFlowerBlocks.orechidIgnem), EntryStacks.of(BotaniaFlowerBlocks.orechidIgnemFloating));
		helper.addWorkstations(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, EntryStacks.of(BotaniaFlowerBlocks.marimorphosis), EntryStacks.of(BotaniaFlowerBlocks.marimorphosisFloating),
				EntryStacks.of(BotaniaFlowerBlocks.marimorphosisChibi), EntryStacks.of(BotaniaFlowerBlocks.marimorphosisChibiFloating));
		helper.addWorkstations(BotaniaREICategoryIdentifiers.PURE_DAISY, EntryStacks.of(BotaniaFlowerBlocks.pureDaisy), EntryStacks.of(BotaniaFlowerBlocks.pureDaisyFloating));
		helper.addWorkstations(BotaniaREICategoryIdentifiers.RUNE_ALTAR, EntryStacks.of(BotaniaBlocks.runeAltar));
		helper.addWorkstations(BotaniaREICategoryIdentifiers.TERRA_PLATE, EntryStacks.of(BotaniaBlocks.terraPlate));

		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.PETAL_APOTHECARY, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.BREWERY, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ELVEN_TRADE, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.MANA_INFUSION, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ORECHID, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.PURE_DAISY, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.RUNE_ALTAR, null);
		helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.TERRA_PLATE, null);
	}

	@Override
	public void registerDisplays(DisplayRegistry helper) {
		registerAncientWillRecipeWrapper(helper);
		registerCompositeLensRecipeWrapper(helper);
		registerTerraPickTippingRecipeWrapper(helper);

		helper.registerFiller(PetalsRecipe.class, PetalApothecaryREIDisplay::new);
		helper.registerFiller(BotanicalBreweryRecipe.class, BreweryREIDisplay::new);
		Predicate<? extends ElvenTradeRecipe> pred = recipe -> !recipe.isReturnRecipe();
		helper.registerFiller(ElvenTradeRecipe.class, pred, ElvenTradeREIDisplay::new);
		helper.registerFiller(LexiconElvenTradeRecipe.class, ElvenTradeREIDisplay::new);
		helper.registerFiller(ManaInfusionRecipe.class, ManaPoolREIDisplay::new);
		helper.registerFiller(PureDaisyRecipe.class, PureDaisyREIDisplay::new);
		helper.registerFiller(RunicAltarRecipe.class, RunicAltarREIDisplay::new);
		helper.registerFiller(RecipeTerraPlate.class, TerrestrialAgglomerationREIDisplay::new);

		try {
			for (var entry : FabricXplatImpl.CUSTOM_STRIPPING.entrySet()) {
				helper.add(new DefaultStrippingDisplay(EntryStacks.of(entry.getKey()), EntryStacks.of(entry.getValue())));
			}
		} catch (Exception e) {
			BotaniaAPI.LOGGER.error("Error adding strippable entry to REI", e);
		}

		helper.registerRecipeFiller(OrechidRecipe.class, BotaniaRecipeTypes.ORECHID_TYPE,
				OrechidREIDisplay::new);
		helper.registerRecipeFiller(OrechidIgnemRecipe.class, BotaniaRecipeTypes.ORECHID_IGNEM_TYPE,
				OrechidIgnemREIDisplay::new);
		helper.registerRecipeFiller(MarimorphosisRecipe.class, BotaniaRecipeTypes.MARIMORPHOSIS_TYPE,
				MarimorphosisREIDisplay::new);
	}

	void registerAncientWillRecipeWrapper(DisplayRegistry helper) {
		ImmutableList.Builder<EntryIngredient> input = ImmutableList.builder();
		ImmutableList.Builder<EntryStack<class_1799>> output = ImmutableList.builder();
		Set<class_1799> wills = ImmutableSet.of(new class_1799(BotaniaItems.ancientWillAhrim), new class_1799(BotaniaItems.ancientWillDharok), new class_1799(BotaniaItems.ancientWillGuthan), new class_1799(BotaniaItems.ancientWillKaril), new class_1799(BotaniaItems.ancientWillTorag), new class_1799(BotaniaItems.ancientWillVerac));
		AncientWillContainer container = (AncientWillContainer) BotaniaItems.terrasteelHelm;

		class_1799 helmet = new class_1799(BotaniaItems.terrasteelHelm);
		input.add(EntryIngredients.of(helmet));
		input.add(EntryIngredients.ofItemStacks(wills));
		for (class_1799 will : wills) {
			class_1799 copy = helmet.method_7972();
			container.addAncientWill(copy, ((AncientWillItem) will.method_7909()).type);
			output.add(EntryStacks.of(copy));
		}
		helper.add(new DefaultCustomDisplay(null, input.build(), Collections.singletonList(EntryIngredient.of(output.build()))));
	}

	void registerCompositeLensRecipeWrapper(DisplayRegistry helper) {
		List<class_1799> lensStacks =
				StreamSupport.stream(class_2378.field_11142.method_40286(BotaniaTags.Items.LENS).spliterator(), false)
						.map(class_1799::new)
						.filter(s -> !((LensItem) s.method_7909()).isControlLens(s))
						.filter(s -> ((LensItem) s.method_7909()).isCombinable(s))
						.toList();
		List<class_1792> lenses = lensStacks.stream().map(class_1799::method_7909).toList();
		List<EntryIngredient> inputs = Arrays.asList(EntryIngredients.ofItemStacks(lensStacks), EntryIngredients.of(new class_1799(class_1802.field_8777)), EntryIngredients.ofItemStacks(lensStacks));
		int end = lenses.size() - 1;

		List<class_1799> firstInput = new ArrayList<>();
		List<class_1799> secondInput = new ArrayList<>();
		List<class_1799> outputs = new ArrayList<>();
		for (int i = 1; i <= end; i++) {
			class_1799 firstLens = new class_1799(lenses.get(i));
			for (class_1792 secondLens : lenses) {
				if (secondLens == firstLens.method_7909()) {
					continue;
				}

				class_1799 secondLensStack = new class_1799(secondLens);
				if (((LensItem) firstLens.method_7909()).canCombineLenses(firstLens, secondLensStack)) {
					firstInput.add(firstLens);
					secondInput.add(secondLensStack);
					outputs.add(((LensItem) firstLens.method_7909()).setCompositeLens(firstLens.method_7972(), secondLensStack));
				}
			}
		}
		inputs.set(0, EntryIngredients.ofItemStacks(firstInput));
		inputs.set(2, EntryIngredients.ofItemStacks(secondInput));

		helper.add(new DefaultCustomDisplay(null, inputs, Collections.singletonList(EntryIngredients.ofItemStacks(outputs))));
	}

	void registerTerraPickTippingRecipeWrapper(DisplayRegistry helper) {
		List<EntryIngredient> inputs = ImmutableList.of(EntryIngredients.of(BotaniaItems.terraPick), EntryIngredients.of(BotaniaItems.elementiumPick));
		class_1799 output = new class_1799(BotaniaItems.terraPick);
		TerraShattererItem.setTipped(output);

		helper.add(new DefaultCustomDisplay(null, inputs, Collections.singletonList(EntryIngredients.of(output))));
	}

	private static class_1799 getHoveredREIStack() {
		return REIRuntime.getInstance().getOverlay().map(o -> {
			class_1799 stack;
			if (REIRuntime.getInstance().isOverlayVisible()) {
				stack = unwrapEntry(o.getEntryList().getFocusedStack());
				if (!stack.method_7960()) {
					return stack;
				}
				stack = o.getFavoritesList()
						.map(OverlayListWidget::getFocusedStack)
						.map(BotaniaREIPlugin::unwrapEntry)
						.orElse(class_1799.field_8037);
				if (!stack.method_7960()) {
					return stack;
				}
			}
			if (class_310.method_1551().field_1755 instanceof DisplayScreen) {
				Point point = PointHelper.ofMouse();
				for (var child : class_310.method_1551().field_1755.method_25396()) {
					if (child.method_25405(point.x, point.y) && child instanceof Slot slot) {
						stack = unwrapEntry(slot.getCurrentEntry());
						if (!stack.method_7960()) {
							return stack;
						}
					}
				}
			}
			return class_1799.field_8037;
		}).orElse(class_1799.field_8037);
	}

	private static class_1799 unwrapEntry(@Nullable EntryStack<?> stack) {
		if (stack != null && !stack.isEmpty() && stack.getType() == VanillaEntryTypes.ITEM) {
			return (class_1799) stack.getValue();
		}
		return class_1799.field_8037;
	}
}
