package vazkii.botania.fabric.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2960;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PureDaisyEmiRecipe extends BotaniaEmiRecipe {
	private static final class_2960 TEXTURE = prefix("textures/gui/pure_daisy_overlay.png");
	private static final EmiStack PURE_DAISY = EmiStack.of(BotaniaFlowerBlocks.pureDaisy);

	public PureDaisyEmiRecipe(PureDaisyRecipe recipe) {
		super(BotaniaEmiPlugin.PURE_DAISY, recipe);
		this.input = List.of(EmiIngredient.of(recipe.getInput().getDisplayed().stream().map(s -> {
			if (s.method_26227().method_15769()) {
				return EmiStack.of(s.method_26204());
			} else {
				return EmiStack.of(s.method_26227().method_15772());
			}
		}).collect(Collectors.toList())));
		this.output = List.of(EmiStack.of(recipe.getOutputState().method_26204()));
	}

	@Override
	public int getDisplayHeight() {
		return 44;
	}

	@Override
	public int getDisplayWidth() {
		return 76;
	}

	@Override
	public void addWidgets(WidgetHolder widgets) {
		addPureDaisyWidgets(widgets, this, input.get(0), PURE_DAISY, output.get(0));
	}

	public static void addPureDaisyWidgets(WidgetHolder widgets, EmiRecipe recipe,
			EmiIngredient input, EmiIngredient flower, EmiStack output) {
		widgets.add(new BlendTextureWidget(TEXTURE, 7, 0, 65, 44, 0, 0));
		widgets.addSlot(input, 0, 13).drawBack(false);
		widgets.addSlot(flower, 29, 13).catalyst(true).drawBack(false);
		widgets.addSlot(output, 58, 13).drawBack(false).recipeContext(recipe);
	}
}
