package vazkii.botania.fabric.integration.emi;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import vazkii.botania.api.recipe.ElvenTradeRecipe;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ElvenTradeEmiRecipe extends BotaniaEmiRecipe {
	private static final class_2960 TEXTURE = prefix("textures/gui/elven_trade_overlay.png");

	public ElvenTradeEmiRecipe(ElvenTradeRecipe recipe) {
		super(BotaniaEmiPlugin.ELVEN_TRADE, recipe);
		this.input = recipe.method_8117().stream().map(EmiIngredient::of).toList();
		this.output = recipe.getOutputs().stream().map(EmiStack::of).toList();
	}

	@Override
	public int getDisplayHeight() {
		return 90;
	}

	@Override
	public int getDisplayWidth() {
		return 120;
	}

	@Override
	public void addWidgets(WidgetHolder widgets) {
		widgets.add(new BlendTextureWidget(TEXTURE, 10, 5, 71, 75, 20, 19));
		widgets.add(new ElevenTradeWidget(12, 22));
		int sx = 35;
		for (EmiIngredient ing : input) {
			widgets.addSlot(ing, sx, 0).drawBack(false);
			sx += 18;
		}
		sx = 83;
		for (EmiStack stack : output) {
			widgets.addSlot(stack, sx, 40).drawBack(false).recipeContext(this);
			sx += 18;
		}
	}

	private static class ElevenTradeWidget extends Widget {
		private final int x, y;

		public ElevenTradeWidget(int x, int y) {
			this.x = x;
			this.y = y;
		}

		@Override
		public Bounds getBounds() {
			return new Bounds(x, y, 0, 0);
		}

		@Override
		public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
			class_1058 sprite = class_310.method_1551().method_1549(class_1723.field_21668)
					.apply(prefix("block/alfheim_portal_swirl"));
			class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
			class_4588 v = immediate.getBuffer(class_1921.method_23577());
			int startX = x;
			int startY = y;
			int stopX = x + 48;
			int stopY = y + 48;
			class_1159 mat = matrices.method_23760().method_23761();
			class_4581 n = matrices.method_23760().method_23762();
			v.method_22918(mat, startX, startY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4594(), sprite.method_4593()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
			v.method_22918(mat, startX, stopY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4594(), sprite.method_4575()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
			v.method_22918(mat, stopX, stopY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4577(), sprite.method_4575()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
			v.method_22918(mat, stopX, startY, 0).method_22915(1f, 1f, 1f, 1f).method_22913(sprite.method_4577(), sprite.method_4593()).method_22916(0xF000F0).method_23763(n, 1, 0, 0).method_1344();
			immediate.method_22993();
		}

	}
}
