package vazkii.botania.fabric.data;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

import java.util.function.Consumer;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;

import static vazkii.botania.data.recipes.RecipeProvider.*;

public class FabricRecipeProvider extends BotaniaRecipeProvider {
	public FabricRecipeProvider(class_2403 generator) {
		super(generator);
	}

	@Override
	protected void registerRecipes(Consumer<class_2444> consumer) {
		// Quartz tag
		class_2450.method_10447(BotaniaBlocks.azulejo0)
				.method_10454(class_1802.field_8345)
				.method_10446(FabricItemTagProvider.QUARTZ_BLOCKS)
				.method_10442("has_item", conditionsFromItem(class_1802.field_8345))
				.method_10431(consumer);

		// Chest tag
		class_2447.method_10437(BotaniaItems.baubleBox)
				.method_10433('C', FabricItemTagProvider.WOODEN_CHESTS)
				.method_10434('G', class_1802.field_8695)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439(" M ")
				.method_10439("MCG")
				.method_10439(" M ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);

		registerRedStringBlock(consumer, BotaniaBlocks.redStringContainer, class_1856.method_8106(FabricItemTagProvider.WOODEN_CHESTS), conditionsFromTag(FabricItemTagProvider.WOODEN_CHESTS));
		class_2450.method_10447(BotaniaBlocks.corporeaRetainer)
				.method_10446(FabricItemTagProvider.WOODEN_CHESTS)
				.method_10454(BotaniaItems.corporeaSpark)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.corporeaSpark))
				.method_10431(consumer);
	}

	@Override
	public String method_10321() {
		return "Botania recipes (Fabric-specific)";
	}
}
