package vazkii.botania.fabric.data;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.relic.DiceOfFateItem;

import static vazkii.botania.common.item.BotaniaItems.*;

import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2466;
import net.minecraft.class_2471;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class FabricItemTagProvider extends class_2471 {
	public static final class_6862<class_1792> QUARTZ_BLOCKS = itemTag(new class_2960("c", "quartz_blocks"));
	private static final class_6862<class_1792> MUSHROOMS = itemTag(new class_2960("c", "mushrooms"));
	private static final class_6862<class_1792> GLASS = itemTag(new class_2960("c", "glass"));
	private static final class_6862<class_1792> GLASS_ALT = itemTag(new class_2960("c", "glass_blocks"));
	private static final class_6862<class_1792> GLASS_PANE = itemTag(new class_2960("c", "glass_pane"));
	private static final class_6862<class_1792> GLASS_PANE_ALT = itemTag(new class_2960("c", "glass_panes"));
	public static final class_6862<class_1792> WOODEN_CHESTS = itemTag(new class_2960("c", "wooden_chests"));

	private static class_6862<class_1792> itemTag(class_2960 location) {
		return class_6862.method_40092(class_2378.field_25108, location);
	}

	public FabricItemTagProvider(class_2403 dataGenerator, class_2466 blockTagsProvider) {
		super(dataGenerator, blockTagsProvider);
	}

	@Override
	protected void method_10514() {
		for (var color : class_1767.values()) {
			this.method_10512(MUSHROOMS).method_26793(BotaniaBlocks.getMushroom(color).method_8389());
		}
		this.method_10505(FabricBlockTagProvider.MUSHROOMS, MUSHROOMS);
		this.method_10505(FabricBlockTagProvider.QUARTZ_BLOCKS, QUARTZ_BLOCKS);
		this.method_10505(FabricBlockTagProvider.GLASS, GLASS);
		this.method_10505(FabricBlockTagProvider.GLASS_ALT, GLASS_ALT);
		this.method_10505(FabricBlockTagProvider.GLASS_PANE, GLASS_PANE);
		this.method_10505(FabricBlockTagProvider.GLASS_PANE_ALT, GLASS_PANE_ALT);
		this.method_10512(WOODEN_CHESTS).method_26795(class_1802.field_8106, class_1802.field_8247);
		generateToolTags();
		generateAccessoryTags();
		generateCompatTags();
	}

	private void generateToolTags() {
		// TODO unhardcode once Fabric API has TagKey constants
		this.method_10512(fabric("axes")).method_26795(manasteelAxe, elementiumAxe, terraAxe);
		this.method_10512(fabric("hoes")).method_26795(manasteelHoe, elementiumHoe);
		this.method_10512(fabric("pickaxes")).method_26795(manasteelPick, elementiumPick, terraPick, glassPick);
		this.method_10512(fabric("shovels")).method_26795(manasteelShovel, elementiumShovel);
		this.method_10512(fabric("swords")).method_26795(manasteelSword, elementiumSword, terraSword, thunderSword, starSword);
		this.method_10512(fabric("shears")).method_26795(manasteelShears, elementiumShears);
	}

	private class_6862<class_1792> fabric(String name) {
		return class_6862.method_40092(class_2378.field_25108, new class_2960("fabric", name));
	}

	private void generateAccessoryTags() {
		this.method_10512(accessory("chest/cape")).method_26795(
				balanceCloak,
				holyCloak,
				invisibilityCloak,
				unholyCloak
		);
		this.method_10512(accessory("chest/necklace")).method_26795(
				bloodPendant,
				cloudPendant,
				divaCharm,
				goddessCharm,
				icePendant,
				lavaPendant,
				superCloudPendant,
				superLavaPendant,
				thirdEye
		);
		class_1792[] rings = {
				auraRing,
				auraRingGreater,
				dodgeRing,
				lokiRing,
				magnetRing,
				magnetRingGreater,
				manaRing,
				manaRingGreater,
				miningRing,
				odinRing,
				pixieRing,
				reachRing,
				swapRing,
				thorRing,
				waterRing
		};
		this.method_10512(accessory("hand/ring")).method_26795(rings);
		this.method_10512(accessory("offhand/ring")).method_26795(rings);
		this.method_10512(accessory("head/face")).method_26795(
				itemFinder,
				monocle,
				tinyPlanet
		);
		this.method_10512(accessory("head/hat")).method_26793(
				flightTiara
		);
		this.method_10512(accessory("legs/belt")).method_26795(
				knockbackBelt,
				speedUpBelt,
				superTravelBelt,
				travelBelt
		);
		this.method_10512(accessory("all")).method_26795(
				blackBowtie, blackTie,
				redGlasses, puffyScarf,
				engineerGoggles, eyepatch,
				wickedEyepatch, redRibbons,
				pinkFlowerBud, polkaDottedBows,
				blueButterfly, catEars,
				witchPin, devilTail,
				kamuiEye, googlyEyes,
				fourLeafClover, clockEye,
				unicornHorn, devilHorns,
				hyperPlus, botanistEmblem,
				ancientMask, eerieMask,
				alienAntenna, anaglyphGlasses,
				orangeShades, grouchoGlasses,
				thickEyebrows, lusitanicShield,
				tinyPotatoMask, questgiverMark,
				thinkingHand
		);
	}

	private void generateCompatTags() {
		this.method_10512(itemTag(new class_2960("modern_industrialization", "replicator_blacklist")))
				.method_26795(DiceOfFateItem.RELIC_STACKS.get().stream().map(class_1799::method_7909).toArray(class_1792[]::new))
				.method_26795(dice, manaTablet, manaRing, manaRingGreater, blackerLotus, blackHoleTalisman, flowerBag,
						spawnerMover, terraPick, BotaniaBlocks.terrasteelBlock.method_8389());
	}

	private static class_6862<class_1792> accessory(String name) {
		return itemTag(new class_2960("trinkets", name));
	}
}
