/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.data;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2403;
import vazkii.botania.data.*;
import vazkii.botania.data.recipes.*;

public class FabricDatagenInitializer implements DataGeneratorEntrypoint {
	@Override
	public void onInitializeDataGenerator(FabricDataGenerator generator) {
		if (System.getProperty("botania.xplat_datagen") != null) {
			configureXplatDatagen(generator);
		} else {
			configureFabricDatagen(generator);
		}
	}

	private static void configureFabricDatagen(class_2403 generator) {
		generator.method_10314(true, new FabricBlockLootProvider(generator));
		var blockTagProvider = new FabricBlockTagProvider(generator);
		generator.method_10314(true, blockTagProvider);
		generator.method_10314(true, new FabricItemTagProvider(generator, blockTagProvider));
		generator.method_10314(true, new FabricRecipeProvider(generator));
		generator.method_10314(true, new FabricBiomeTagProvider(generator));
	}

	private static void configureXplatDatagen(class_2403 generator) {
		generator.method_10314(true, new BlockLootProvider(generator));
		BlockTagProvider blockTagProvider = new BlockTagProvider(generator);
		generator.method_10314(true, blockTagProvider);
		generator.method_10314(true, new ItemTagProvider(generator, blockTagProvider));
		generator.method_10314(true, new EntityTagProvider(generator));
		generator.method_10314(true, new BannerTagProvider(generator));
		generator.method_10314(true, new BiomeTagProvider(generator));
		generator.method_10314(true, new StonecuttingProvider(generator));
		generator.method_10314(true, new RecipeProvider(generator));
		generator.method_10314(true, new SmeltingProvider(generator));
		generator.method_10314(true, new ElvenTradeProvider(generator));
		generator.method_10314(true, new ManaInfusionProvider(generator));
		generator.method_10314(true, new PureDaisyProvider(generator));
		generator.method_10314(true, new BrewProvider(generator));
		generator.method_10314(true, new PetalApothecaryProvider(generator));
		generator.method_10314(true, new RunicAltarProvider(generator));
		generator.method_10314(true, new TerrestrialAgglomerationProvider(generator));
		generator.method_10314(true, new OrechidProvider(generator));
		generator.method_10314(true, new BlockstateProvider(generator));
		generator.method_10314(true, new FloatingFlowerModelProvider(generator));
		generator.method_10314(true, new ItemModelProvider(generator));
		generator.method_10314(true, new AdvancementProvider(generator));
	}
}
