package vazkii.botania.fabric.data;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFluffBlocks;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2466;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_6862;

public class FabricBlockTagProvider extends class_2466 {
	public static final class_6862<class_2248> LAPIS_BLOCKS = blockTag(new class_2960("c", "lapis_blocks"));
	public static final class_6862<class_2248> QUARTZ_BLOCKS = blockTag(new class_2960("c", "quartz_blocks"));
	public static final class_6862<class_2248> MUSHROOMS = blockTag(new class_2960("c", "mushrooms"));
	public static final class_6862<class_2248> GLASS = blockTag(new class_2960("c", "glass"));
	public static final class_6862<class_2248> GLASS_ALT = blockTag(new class_2960("c", "glass_blocks"));
	public static final class_6862<class_2248> GLASS_PANE = blockTag(new class_2960("c", "glass_pane"));
	public static final class_6862<class_2248> GLASS_PANE_ALT = blockTag(new class_2960("c", "glass_panes"));

	private static class_6862<class_2248> blockTag(class_2960 location) {
		return class_6862.method_40092(class_2378.field_25105, location);
	}

	public FabricBlockTagProvider(class_2403 dataGenerator) {
		super(dataGenerator);
	}

	@Override
	protected void method_10514() {
		method_10512(LAPIS_BLOCKS).method_26793(class_2246.field_10441);
		method_10512(QUARTZ_BLOCKS).method_26795(
				BotaniaFluffBlocks.darkQuartz, BotaniaFluffBlocks.manaQuartz, BotaniaFluffBlocks.blazeQuartz,
				BotaniaFluffBlocks.lavenderQuartz, BotaniaFluffBlocks.redQuartz, BotaniaFluffBlocks.elfQuartz, BotaniaFluffBlocks.sunnyQuartz
		);
		List.of(GLASS, GLASS_ALT).forEach(t -> method_10512(t).method_26795(BotaniaBlocks.manaGlass, BotaniaBlocks.elfGlass, BotaniaBlocks.bifrostPerm));
		List.of(GLASS_PANE, GLASS_PANE_ALT).forEach(t -> method_10512(t).method_26795(BotaniaFluffBlocks.managlassPane, BotaniaFluffBlocks.alfglassPane, BotaniaFluffBlocks.bifrostPane));

		for (class_1767 color : class_1767.values()) {
			this.method_10512(MUSHROOMS).method_26793(BotaniaBlocks.getMushroom(color));
		}

		var vanillaTags = List.of(
				class_3481.field_29193,
				class_3481.field_28988,
				class_3481.field_23062,
				class_3481.field_28991,
				class_3481.field_28990,
				class_3481.field_28989,
				class_3481.field_29195,
				class_3481.field_29194
		);
		// We aren't calling vanilla's generation, so need to add dummy calls so that using them below doesn't error out.
		vanillaTags.forEach(this::method_10512);

		var oreTag = method_10512(XplatAbstractions.INSTANCE.getOreTag());
		vanillaTags.forEach(oreTag::method_26792);
	}
}
