/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.*;
import java.util.function.Function;
import java.util.function.Supplier;

/*
 * NB: We extend BlockModel only as an artifact of where we inject our mixin.
 * Pretty much all of the data of the superclass is ignored.
 */
public class FabricFloatingFlowerModel extends class_793 {
	private final class_1100 unbakedFlower;
	private final Map<FloatingFlower.IslandType, class_1100> unbakedIslands = new HashMap<>();

	private FabricFloatingFlowerModel(class_1100 flower) {
		super(null, Collections.emptyList(), Collections.emptyMap(), false, class_4751.field_21859, class_809.field_4301, Collections.emptyList());
		this.unbakedFlower = flower;
	}

	@Override
	public Collection<class_2960> method_4755() {
		return Collections.emptyList();
	}

	@NotNull
	@Override
	public Collection<class_4730> method_4754(Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
		Set<class_4730> ret = new HashSet<>();
		for (Map.Entry<FloatingFlower.IslandType, class_2960> e : BotaniaAPIClient.instance().getRegisteredIslandTypeModels().entrySet()) {
			class_1100 unbakedIsland = modelGetter.apply(e.getValue());
			ret.addAll(unbakedIsland.method_4754(modelGetter, missingTextureErrors));
			unbakedIslands.put(e.getKey(), unbakedIsland);
		}
		ret.addAll(unbakedFlower.method_4754(modelGetter, missingTextureErrors));
		return ret;
	}

	@Nullable
	@Override
	public class_1087 method_4753(class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_2960 name) {
		final class_4590 moveFlower = new class_4590(new class_1160(0F, 0.2F, 0F), null, new class_1160(0.5F, 0.5F, 0.5F), null);
		class_4590 mul = moveFlower.method_22933(transform.method_3509());
		class_3665 newTransform = new class_3665() {
			@Override
			public class_4590 method_3509() {
				return mul;
			}

			@Override
			public boolean method_3512() {
				return transform.method_3512();
			}
		};
		class_1087 bakedFlower = unbakedFlower.method_4753(bakery, spriteGetter, newTransform, name);

		Map<FloatingFlower.IslandType, class_1087> bakedIslands = new HashMap<>();
		for (Map.Entry<FloatingFlower.IslandType, class_1100> e : unbakedIslands.entrySet()) {
			class_1087 bakedIsland = e.getValue().method_4753(bakery, spriteGetter, transform, name);
			bakedIslands.put(e.getKey(), bakedIsland);
		}
		return new Baked(bakedFlower, bakedIslands);
	}

	public static class Baked extends ForwardingBakedModel {
		private final Map<FloatingFlower.IslandType, class_1087> islands;

		Baked(class_1087 flower, Map<FloatingFlower.IslandType, class_1087> islands) {
			this.wrapped = flower;
			this.islands = islands;
		}

		private void emit(FloatingFlower.IslandType type, RenderContext ctx) {
			ctx.fallbackConsumer().accept(wrapped);
			ctx.fallbackConsumer().accept(islands.get(type));
		}

		@NotNull
		@Override
		public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, @NotNull class_5819 rand) {
			List<class_777> flower = wrapped.method_4707(null, null, rand);
			List<class_777> island = islands.get(FloatingFlower.IslandType.GRASS).method_4707(null, null, rand);
			List<class_777> ret = new ArrayList<>(flower.size() + island.size());
			ret.addAll(flower);
			ret.addAll(island);
			return ret;
		}

		@Override
		public boolean isVanillaAdapter() {
			return false;
		}

		@Override
		public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
			emit(FloatingFlower.IslandType.GRASS, context);
		}

		@Override
		public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
			Object data = ((RenderAttachedBlockView) blockView).getBlockEntityRenderAttachment(pos);
			if (data instanceof FloatingFlower.IslandType type) {
				emit(type, context);
			}
		}
	}

	public static void hookModelLoad(JsonElement jsonElement, JsonDeserializationContext context, CallbackInfoReturnable<class_793> cir) {
		JsonObject json = jsonElement.getAsJsonObject();
		JsonElement loader = json.get("loader");
		if (loader != null && loader.isJsonPrimitive()
				&& loader.getAsString().equals(ClientXplatAbstractions.FLOATING_FLOWER_MODEL_LOADER_ID.toString())) {
			class_793 flowerModel = context.deserialize(json.getAsJsonObject("flower"), class_793.class);
			cir.setReturnValue(new FabricFloatingFlowerModel(flowerModel));
		}
	}
}
