package vazkii.botania.fabric.client;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1044;
import net.minecraft.class_1087;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3902;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaFabricClientCapabilities;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.item.TinyPotatoRenderCallback;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class FabricClientXplatImpl implements ClientXplatAbstractions {
	@Override
	public void fireRenderTinyPotato(class_2586 potato, class_2561 name, float tickDelta, class_4587 ms, class_4597 buffers, int light, int overlay) {
		TinyPotatoRenderCallback.EVENT.invoker().onRender(potato, name, tickDelta, ms, buffers, light, overlay);
	}

	@Override
	public void sendToServer(BotaniaPacket packet) {
		ClientPlayNetworking.send(packet.getFabricId(), packet.toBuf());
	}

	@Nullable
	@Override
	public WandHUD findWandHud(class_1937 level, class_2338 pos, class_2680 state, class_2586 be) {
		return BotaniaFabricClientCapabilities.WAND_HUD.find(level, pos, state, be, class_3902.field_17274);
	}

	@Override
	public class_1087 wrapPlatformModel(class_1087 original) {
		return new FabricPlatformModel(original);
	}

	@Override
	public void setFilterSave(class_1044 texture, boolean filter, boolean mipmap) {
		((ExtendedTexture) texture).setFilterSave(filter, mipmap);
	}

	@Override
	public void restoreLastFilter(class_1044 texture) {
		((ExtendedTexture) texture).restoreLastFilter();
	}

	@Override
	public void tessellateBlock(class_1937 level, class_2680 state, class_2338 pos, class_4587 ps, class_4597 buffers, int overlay) {
		var brd = class_310.method_1551().method_1541();
		var buffer = buffers.getBuffer(class_4696.method_23683(state, false));
		brd.method_3350().method_3374(level, brd.method_3349(state), state, pos, ps,
				buffer, true, class_5819.method_43047(), state.method_26190(pos), overlay);
	}
}
