package vazkii.botania.fabric.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.*;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1007;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_5617;
import net.minecraft.class_707;
import net.minecraft.class_922;
import vazkii.botania.api.BotaniaFabricClientCapabilities;
import vazkii.botania.client.BotaniaItemProperties;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.core.handler.KonamiHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.fx.BotaniaParticles;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.gui.ManaBarTooltipComponent;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.client.gui.bag.FlowerPouchGui;
import vazkii.botania.client.gui.box.BaubleBoxGui;
import vazkii.botania.client.integration.ears.EarsIntegration;
import vazkii.botania.client.model.BotaniaLayerDefinitions;
import vazkii.botania.client.model.armor.ArmorModel;
import vazkii.botania.client.model.armor.ArmorModels;
import vazkii.botania.client.render.BlockRenderLayers;
import vazkii.botania.client.render.ColorHandler;
import vazkii.botania.client.render.block_entity.TEISR;
import vazkii.botania.client.render.entity.*;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.fabric.network.FabricPacketHandler;
import vazkii.botania.mixin.client.RenderBuffersAccessor;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.BookDrawScreenCallback;
import java.util.Map.Entry;
import java.util.SortedMap;
import java.util.function.Function;

public class FabricClientInitializer implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
		FabricPacketHandler.initClient();

		// Guis
		ScreenRegistry.register(BotaniaItems.FLOWER_BAG_CONTAINER, FlowerPouchGui::new);
		ScreenRegistry.register(BotaniaItems.BAUBLE_BOX_CONTAINER, BaubleBoxGui::new);

		// Blocks and Items
		ModelLoadingRegistry.INSTANCE.registerModelProvider(MiscellaneousModels.INSTANCE::onModelRegister);
		BlockRenderLayers.init(BlockRenderLayerMap.INSTANCE::putBlock);
		BotaniaItemProperties.init((i, id, propGetter) -> FabricModelPredicateProviderRegistry.register(i.method_8389(), id, propGetter));

		// BE/Entity Renderer
		BotaniaLayerDefinitions.init((loc, supplier) -> EntityModelLayerRegistry.registerModelLayer(loc, supplier::get));
		EntityRenderers.registerBlockEntityRenderers(BlockEntityRendererRegistry::register);
		for (var pair : EntityRenderers.BE_ITEM_RENDERER_FACTORIES.entrySet()) {
			var block = pair.getKey();
			var renderer = pair.getValue().apply(block);
			BuiltinItemRendererRegistry.INSTANCE.register(block, renderer::render);
		}
		EntityRenderers.registerEntityRenderers(EntityRendererRegistry::register);
		LivingEntityFeatureRendererRegistrationCallback.EVENT.register(this::initAuxiliaryRender);

		BotaniaParticles.FactoryHandler.registerFactories(new BotaniaParticles.FactoryHandler.Consumer() {
			@Override
			public <T extends class_2394> void register(class_2396<T> type, Function<class_4002, class_707<T>> constructor) {
				ParticleFactoryRegistry.getInstance().register(type, constructor::apply);
			}
		});

		// Events
		BookDrawScreenCallback.EVENT.register(KonamiHandler::renderBook);
		ClientLifecycleEvents.CLIENT_STARTED.register(this::loadComplete);
		ClientTickEvents.END_CLIENT_TICK.register(ClientTickHandler::clientTickEnd);
		ClientTickEvents.END_CLIENT_TICK.register(KonamiHandler::clientTick);
		HudRenderCallback.EVENT.register(HUDHandler::onDrawScreenPost);
		ItemTooltipCallback.EVENT.register(TooltipHandler::onTooltipEvent);
		ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenKeyboardEvents.beforeKeyPress(screen)
				.register((screen2, key, scancode, modifiers) -> CorporeaInputHandler.buttonPressed(key, scancode)));
		TooltipComponentCallback.EVENT.register(ManaBarTooltipComponent::tryConvert);

		// Etc
		ClientProxy.initSeasonal();
		ClientProxy.initKeybindings(KeyBindingHelper::registerKeyBinding);

		registerArmors();
		registerCapabilities();

		if (XplatAbstractions.INSTANCE.isModLoaded("ears")) {
			EarsIntegration.register();
		}
	}

	private static void registerCapabilities() {
		BotaniaBlockEntities.registerWandHudCaps((factory, types) -> BotaniaFabricClientCapabilities.WAND_HUD.registerForBlockEntities((be, c) -> factory.apply(be), types));
		BotaniaFlowerBlocks.registerWandHudCaps((factory, types) -> BotaniaFabricClientCapabilities.WAND_HUD.registerForBlockEntities((be, c) -> factory.apply(be), types));
	}

	private static void registerArmors() {
		class_1792[] armors = class_2378.field_11142.method_10220()
				.filter(i -> i instanceof ManasteelArmorItem
						&& class_2378.field_11142.method_10221(i).method_12836().equals(LibMisc.MOD_ID))
				.toArray(class_1792[]::new);

		ArmorRenderer renderer = (matrices, vertexConsumers, stack, entity, slot, light, contextModel) -> {
			ManasteelArmorItem armor = (ManasteelArmorItem) stack.method_7909();
			var model = ArmorModels.get(stack);
			var texture = armor.getArmorTexture(stack, entity, slot, "");
			if (model != null) {
				contextModel.method_2818(model);
				ArmorRenderer.renderPart(matrices, vertexConsumers, light, stack, model, new class_2960(texture));
			}
		};
		ArmorRenderer.register(renderer, armors);
	}

	private void loadComplete(class_310 mc) {
		ColorHandler.submitBlocks(ColorProviderRegistry.BLOCK::register);
		ColorHandler.submitItems(ColorProviderRegistry.ITEM::register);

		// Needed to prevent mana pools on carts from X-raying through the cart
		SortedMap<class_1921, class_287> layers = ((RenderBuffersAccessor) mc.method_22940()).getEntityBuilders();
		layers.put(RenderHelper.MANA_POOL_WATER, new class_287(RenderHelper.MANA_POOL_WATER.method_22722()));
	}

	private void initAuxiliaryRender(class_1299<? extends class_1309> type, class_922<?, ?> renderer,
			LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper helper, class_5617.class_5618 ctx) {
		if (type == class_1299.field_6097 && renderer instanceof class_1007 playerRenderer) {
			EntityRenderers.addAuxiliaryPlayerRenders(playerRenderer, helper::register);
		}
	}
}
