package vazkii.botania.fabric.block_entity;

import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.block_entity.red_string.RedStringContainerBlockEntity;
import vazkii.botania.fabric.internal_caps.RedStringContainerStorage;

public class FabricRedStringContainerBlockEntity extends RedStringContainerBlockEntity {
	private final RedStringContainerStorage[] storages = new RedStringContainerStorage[class_2350.values().length];
	private class_2338 clientPos;

	public FabricRedStringContainerBlockEntity(class_2338 pos, class_2680 state) {
		super(pos, state);
	}

	public static Storage<ItemVariant> getStorage(RedStringContainerBlockEntity container, class_2350 direction) {
		if (container instanceof FabricRedStringContainerBlockEntity c) {
			return c.storage(direction);
		}
		return null;
	}

	public Storage<ItemVariant> storage(class_2350 direction) {
		int ordinal = direction.ordinal();
		if (storages[ordinal] == null) {
			storages[ordinal] = new RedStringContainerStorage(this, direction);
		}
		return storages[ordinal];
	}

	@Override
	public void onBound(class_2338 pos) {
		VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		// We cannot query for the storage api on the client - so we send the binding position.
		class_2338 binding = getBinding();
		if (binding == null) {
			// hack: empty NBT gets the packet ignored but we don't want that
			cmp.method_10567("-", (byte) 0);
			return;
		}
		cmp.method_10569("bindX", binding.method_10263());
		cmp.method_10569("bindY", binding.method_10264());
		cmp.method_10569("bindZ", binding.method_10260());
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		if (cmp.method_10545("bindX")) {
			clientPos = new class_2338(cmp.method_10550("bindX"), cmp.method_10550("bindY"), cmp.method_10550("bindZ"));
		} else {
			clientPos = null;
		}
	}

	@Nullable
	@Override
	public class_2338 getBinding() {
		return field_11863.field_9236 ? clientPos : super.getBinding();
	}
}
