/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric;

import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.LibMisc;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class FabricBotaniaCreativeTab extends class_1761 {
	public static final FabricBotaniaCreativeTab INSTANCE;
	static {
		// Use FabricItemGroupBuilder#build only for its side-effect of expanding the size of the global static array of CreativeModeTabs by one.
		class_1761 sacrificial = FabricItemGroupBuilder.build(prefix("sacrificial_tab"), () -> new class_1799(BotaniaItems.thinkingHand));

		// Slot a new creative tab into its place. (CreativeModeTab does this in its constructor.)
		INSTANCE = new FabricBotaniaCreativeTab(sacrificial.method_7741(), LibMisc.MOD_ID);
	}

	public FabricBotaniaCreativeTab(int index, String langId) {
		super(index, langId);
		method_7748();
		method_7753(ResourcesLib.GUI_CREATIVE);
	}

	@NotNull
	@Override
	public class_1799 method_7750() {
		return new class_1799(BotaniaItems.lexicon);
	}
}
