/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;

import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2403;
import net.minecraft.class_2960;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class TerrestrialAgglomerationProvider extends BotaniaRecipeProvider {
	public TerrestrialAgglomerationProvider(class_2403 gen) {
		super(gen);
	}

	@Override
	public String method_10321() {
		return "Botania Terra Plate recipes";
	}

	@Override
	public void registerRecipes(Consumer<net.minecraft.class_2444> consumer) {
		consumer.accept(new FinishedRecipe(idFor("terrasteel_ingot"), ManaPoolBlockEntity.MAX_MANA / 2,
				new class_1799(BotaniaItems.terrasteel), class_1856.method_8091(BotaniaItems.manaSteel),
				class_1856.method_8091(BotaniaItems.manaPearl), class_1856.method_8091(BotaniaItems.manaDiamond)));
	}

	private static class_2960 idFor(String s) {
		return prefix("terra_plate/" + s);
	}

	protected static class FinishedRecipe implements net.minecraft.class_2444 {
		private final class_2960 id;
		private final int mana;
		private final class_1799 output;
		private final class_1856[] inputs;

		public FinishedRecipe(class_2960 id, int mana, class_1799 output, class_1856... inputs) {
			this.id = id;
			this.mana = mana;
			this.output = output;
			this.inputs = inputs;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.addProperty("mana", mana);
			JsonArray ingredients = new JsonArray();
			for (class_1856 ingr : inputs) {
				ingredients.add(ingr.method_8089());
			}
			json.add("ingredients", ingredients);
			json.add("result", ItemNBTHelper.serializeStack(output));
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return BotaniaRecipeTypes.TERRA_PLATE_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}
}
