/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFluffBlocks;

import java.util.function.Consumer;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2454;

public class SmeltingProvider extends BotaniaRecipeProvider {
	public SmeltingProvider(class_2403 generatorIn) {
		super(generatorIn);
	}

	private static class_2066.class_2068 conditionsFromItem(class_1935 item) {
		return RecipeProvider.conditionsFromItem(item);
	}

	@Override
	public void registerRecipes(Consumer<class_2444> consumer) {
		class_2454.method_17802(class_1856.method_8091(BotaniaFluffBlocks.biomeCobblestoneForest), BotaniaFluffBlocks.biomeStoneForest, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaFluffBlocks.biomeCobblestoneForest))
				.method_36443(consumer, "botania:smelting/metamorphic_forest_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaFluffBlocks.biomeCobblestonePlains), BotaniaFluffBlocks.biomeStonePlains, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaFluffBlocks.biomeCobblestonePlains))
				.method_36443(consumer, "botania:smelting/metamorphic_plains_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaFluffBlocks.biomeCobblestoneMountain), BotaniaFluffBlocks.biomeStoneMountain, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaFluffBlocks.biomeCobblestoneMountain))
				.method_36443(consumer, "botania:smelting/metamorphic_mountain_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaFluffBlocks.biomeCobblestoneFungal), BotaniaFluffBlocks.biomeStoneFungal, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaFluffBlocks.biomeCobblestoneFungal))
				.method_36443(consumer, "botania:smelting/metamorphic_fungal_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaFluffBlocks.biomeCobblestoneSwamp), BotaniaFluffBlocks.biomeStoneSwamp, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaFluffBlocks.biomeCobblestoneSwamp))
				.method_36443(consumer, "botania:smelting/metamorphic_swamp_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaFluffBlocks.biomeCobblestoneDesert), BotaniaFluffBlocks.biomeStoneDesert, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaFluffBlocks.biomeCobblestoneDesert))
				.method_36443(consumer, "botania:smelting/metamorphic_desert_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaFluffBlocks.biomeCobblestoneTaiga), BotaniaFluffBlocks.biomeStoneTaiga, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaFluffBlocks.biomeCobblestoneTaiga))
				.method_36443(consumer, "botania:smelting/metamorphic_taiga_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaFluffBlocks.biomeCobblestoneMesa), BotaniaFluffBlocks.biomeStoneMesa, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaFluffBlocks.biomeCobblestoneMesa))
				.method_36443(consumer, "botania:smelting/metamorphic_mesa_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.livingrockBrick), BotaniaBlocks.livingrockBrickCracked, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.livingrockBrick))
				.method_36443(consumer, "botania:smelting/cracked_livingrock_bricks");
	}

	@Override
	public String method_10321() {
		return "Botania smelting recipes";
	}
}
