/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PetalApothecaryProvider extends BotaniaRecipeProvider {
	private static final class_1856 DEFAULT_REAGENT = class_1856.method_8106(BotaniaTags.Items.SEED_APOTHECARY_REAGENT);

	public PetalApothecaryProvider(class_2403 gen) {
		super(gen);
	}

	@Override
	public String method_10321() {
		return "Botania petal apothecary recipes";
	}

	@Override
	public void registerRecipes(Consumer<net.minecraft.class_2444> consumer) {
		class_1856 white = tagIngr("petals/white");
		class_1856 orange = tagIngr("petals/orange");
		class_1856 magenta = tagIngr("petals/magenta");
		class_1856 lightBlue = tagIngr("petals/light_blue");
		class_1856 yellow = tagIngr("petals/yellow");
		class_1856 lime = tagIngr("petals/lime");
		class_1856 pink = tagIngr("petals/pink");
		class_1856 gray = tagIngr("petals/gray");
		class_1856 lightGray = tagIngr("petals/light_gray");
		class_1856 cyan = tagIngr("petals/cyan");
		class_1856 purple = tagIngr("petals/purple");
		class_1856 blue = tagIngr("petals/blue");
		class_1856 brown = tagIngr("petals/brown");
		class_1856 green = tagIngr("petals/green");
		class_1856 red = tagIngr("petals/red");
		class_1856 black = tagIngr("petals/black");
		class_1856 runeWater = class_1856.method_8091(BotaniaItems.runeWater);
		class_1856 runeFire = class_1856.method_8091(BotaniaItems.runeFire);
		class_1856 runeEarth = class_1856.method_8091(BotaniaItems.runeEarth);
		class_1856 runeAir = class_1856.method_8091(BotaniaItems.runeAir);
		class_1856 runeSpring = class_1856.method_8091(BotaniaItems.runeSpring);
		class_1856 runeSummer = class_1856.method_8091(BotaniaItems.runeSummer);
		class_1856 runeAutumn = class_1856.method_8091(BotaniaItems.runeAutumn);
		class_1856 runeWinter = class_1856.method_8091(BotaniaItems.runeWinter);
		class_1856 runeMana = class_1856.method_8091(BotaniaItems.runeMana);
		class_1856 runeLust = class_1856.method_8091(BotaniaItems.runeLust);
		class_1856 runeGluttony = class_1856.method_8091(BotaniaItems.runeGluttony);
		class_1856 runeGreed = class_1856.method_8091(BotaniaItems.runeGreed);
		class_1856 runeSloth = class_1856.method_8091(BotaniaItems.runeSloth);
		class_1856 runeWrath = class_1856.method_8091(BotaniaItems.runeWrath);
		class_1856 runeEnvy = class_1856.method_8091(BotaniaItems.runeEnvy);
		class_1856 runePride = class_1856.method_8091(BotaniaItems.runePride);

		class_1856 redstoneRoot = class_1856.method_8091(BotaniaItems.redstoneRoot);
		class_1856 pixieDust = class_1856.method_8091(BotaniaItems.pixieDust);
		class_1856 gaiaSpirit = class_1856.method_8091(BotaniaItems.lifeEssence);

		consumer.accept(make(BotaniaFlowerBlocks.pureDaisy, white, white, white, white));
		consumer.accept(make(BotaniaFlowerBlocks.manastar, lightBlue, green, red, cyan));

		consumer.accept(make(BotaniaFlowerBlocks.endoflame, brown, brown, red, lightGray));
		consumer.accept(make(BotaniaFlowerBlocks.hydroangeas, blue, blue, cyan, cyan));
		consumer.accept(make(BotaniaFlowerBlocks.thermalily, red, orange, orange, runeEarth, runeFire));
		consumer.accept(make(BotaniaFlowerBlocks.rosaArcana, pink, pink, purple, purple, lime, runeMana));
		consumer.accept(make(BotaniaFlowerBlocks.munchdew, lime, lime, red, red, green, runeGluttony));
		consumer.accept(make(BotaniaFlowerBlocks.entropinnyum, red, red, gray, gray, white, white, runeWrath, runeFire));
		consumer.accept(make(BotaniaFlowerBlocks.kekimurus, white, white, orange, orange, brown, brown, runeGluttony, pixieDust));
		consumer.accept(make(BotaniaFlowerBlocks.gourmaryllis, lightGray, lightGray, yellow, yellow, red, runeFire, runeSummer));
		consumer.accept(make(BotaniaFlowerBlocks.narslimmus, lime, lime, green, green, black, runeSummer, runeWater));
		consumer.accept(make(BotaniaFlowerBlocks.spectrolus, red, red, green, green, blue, blue, white, white, runeWinter, runeAir, pixieDust));
		consumer.accept(make(BotaniaFlowerBlocks.rafflowsia, purple, purple, green, green, black, runeEarth, runePride, pixieDust));
		consumer.accept(make(BotaniaFlowerBlocks.shulkMeNot, purple, purple, magenta, magenta, lightGray, gaiaSpirit, runeEnvy, runeWrath));
		consumer.accept(make(BotaniaFlowerBlocks.dandelifeon, purple, purple, lime, green, runeWater, runeFire, runeEarth, runeAir, gaiaSpirit));

		consumer.accept(make(BotaniaFlowerBlocks.jadedAmaranthus, purple, lime, green, runeSpring, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.bellethorn, red, red, red, cyan, cyan, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.dreadthorn, black, black, black, cyan, cyan, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.heiseiDream, magenta, magenta, purple, pink, runeWrath, pixieDust));
		consumer.accept(make(BotaniaFlowerBlocks.tigerseye, yellow, brown, orange, lime, runeAutumn));

		net.minecraft.class_2444 base = make(BotaniaFlowerBlocks.orechid, gray, gray, yellow, green, red, runePride, runeGreed, redstoneRoot, pixieDust);
		net.minecraft.class_2444 gog = make(BotaniaFlowerBlocks.orechid, gray, gray, yellow, yellow, green, green, red, red);
		consumer.accept(new GogAlternationResult(gog, base));

		consumer.accept(make(BotaniaFlowerBlocks.orechidIgnem, red, red, white, white, pink, runePride, runeGreed, redstoneRoot, pixieDust));
		consumer.accept(make(BotaniaFlowerBlocks.fallenKanade, white, white, yellow, yellow, orange, runeSpring));
		consumer.accept(make(BotaniaFlowerBlocks.exoflame, red, red, gray, lightGray, runeFire, runeSummer));
		consumer.accept(make(BotaniaFlowerBlocks.agricarnation, lime, lime, green, yellow, runeSpring, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.hopperhock, gray, gray, lightGray, lightGray, runeAir, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.tangleberrie, cyan, cyan, gray, lightGray, runeAir, runeEarth));
		consumer.accept(make(BotaniaFlowerBlocks.jiyuulia, pink, pink, purple, lightGray, runeWater, runeAir));
		consumer.accept(make(BotaniaFlowerBlocks.rannuncarpus, orange, orange, yellow, runeEarth, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.hyacidus, purple, purple, magenta, magenta, green, runeWater, runeAutumn, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.pollidisiac, red, red, pink, pink, orange, runeLust, runeFire));
		consumer.accept(make(BotaniaFlowerBlocks.clayconia, lightGray, lightGray, gray, cyan, runeEarth));
		consumer.accept(make(BotaniaFlowerBlocks.loonium, green, green, green, green, gray, runeSloth, runeGluttony, runeEnvy, redstoneRoot, pixieDust));
		consumer.accept(make(BotaniaFlowerBlocks.daffomill, white, white, brown, yellow, runeAir, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.vinculotus, black, black, purple, purple, green, runeWater, runeSloth, runeLust, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.spectranthemum, white, white, lightGray, lightGray, cyan, runeEnvy, runeWater, redstoneRoot, pixieDust));
		consumer.accept(make(BotaniaFlowerBlocks.medumone, brown, brown, gray, gray, runeEarth, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.marimorphosis, gray, yellow, green, red, runeEarth, runeFire, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.bubbell, cyan, cyan, lightBlue, lightBlue, blue, blue, runeWater, runeSummer, pixieDust));
		consumer.accept(make(BotaniaFlowerBlocks.solegnolia, brown, brown, red, blue, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.bergamute, orange, green, green, redstoneRoot));
		consumer.accept(make(BotaniaFlowerBlocks.labellia, yellow, yellow, blue, white, black, runeAutumn, redstoneRoot, pixieDust));

		consumer.accept(make(BotaniaBlocks.motifDaybloom, yellow, yellow, orange, lightBlue));
		consumer.accept(make(BotaniaBlocks.motifNightshade, black, black, purple, gray));

		class_1799 stack = new class_1799(class_1802.field_8575);
		ItemNBTHelper.setString(stack, "SkullOwner", "Vazkii");
		class_1856[] inputs = new class_1856[16];
		Arrays.fill(inputs, pink);
		consumer.accept(new NbtOutputResult(
				new FinishedRecipe(idFor(prefix("vazkii_head")), stack, DEFAULT_REAGENT, inputs),
				stack.method_7969()));
	}

	protected static class_1856 tagIngr(String tag) {
		return class_1856.method_8106(class_6862.method_40092(class_2378.field_25108, prefix(tag)));
	}

	protected static FinishedRecipe make(class_1935 item, class_1856... ingredients) {
		return new FinishedRecipe(idFor(class_2378.field_11142.method_10221(item.method_8389())),
				new class_1799(item), DEFAULT_REAGENT, ingredients);
	}

	protected static class_2960 idFor(class_2960 name) {
		return new class_2960(name.method_12836(), "petal_apothecary/" + name.method_12832());
	}

	protected static class FinishedRecipe implements net.minecraft.class_2444 {
		private final class_2960 id;
		private final class_1799 output;
		private final class_1856 reagent;
		private final class_1856[] inputs;

		private FinishedRecipe(class_2960 id, class_1799 output, class_1856 reagent, class_1856... inputs) {
			this.id = id;
			this.output = output;
			this.reagent = reagent;
			this.inputs = inputs;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.add("output", ItemNBTHelper.serializeStack(output));
			JsonArray ingredients = new JsonArray();
			for (class_1856 ingr : inputs) {
				ingredients.add(ingr.method_8089());
			}
			json.add("reagent", reagent.method_8089());
			json.add("ingredients", ingredients);
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return BotaniaRecipeTypes.PETAL_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}
}
