/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaFluffBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.function.Consumer;
import net.minecraft.class_1865;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class OrechidProvider extends BotaniaRecipeProvider {

	public OrechidProvider(class_2403 generator) {
		super(generator);
	}

	// TODO: We had an enormous amount of ores defined for mod compat.
	//       The old data needs to be completely revised.
	@Override
	protected void registerRecipes(Consumer<net.minecraft.class_2444> consumer) {
		consumer.accept(stone(class_2246.field_10418, 67415));
		consumer.accept(stone(class_2246.field_10212, 29371));
		consumer.accept(stone(class_2246.field_10080, 7654));
		consumer.accept(stone(class_2246.field_27120, 7000));
		consumer.accept(stone(class_2246.field_10571, 2647));
		consumer.accept(stone(class_2246.field_10013, 1239));
		consumer.accept(stone(class_2246.field_10090, 1079));
		consumer.accept(stone(class_2246.field_10442, 883));

		consumer.accept(deepslate(class_2246.field_29219, 75));
		consumer.accept(deepslate(class_2246.field_29027, 250));
		consumer.accept(deepslate(class_2246.field_29030, 150));
		consumer.accept(deepslate(class_2246.field_29221, 75));
		consumer.accept(deepslate(class_2246.field_29026, 125));
		consumer.accept(deepslate(class_2246.field_29220, 50));
		consumer.accept(deepslate(class_2246.field_29028, 175));
		consumer.accept(deepslate(class_2246.field_29029, 100));

		consumer.accept(netherrack(class_2246.field_10213, 19600));
		consumer.accept(netherrack(class_2246.field_23077, 3635));
		consumer.accept(netherrack(class_2246.field_22109, 148));

		consumer.accept(biomeStone(BotaniaFluffBlocks.biomeStoneForest, BotaniaTags.Biomes.MARIMORPHOSIS_FOREST_BONUS));
		consumer.accept(biomeStone(BotaniaFluffBlocks.biomeStonePlains, BotaniaTags.Biomes.MARIMORPHOSIS_PLAINS_BONUS));
		consumer.accept(biomeStone(BotaniaFluffBlocks.biomeStoneMountain, BotaniaTags.Biomes.MARIMORPHOSIS_MOUNTAIN_BONUS));
		consumer.accept(biomeStone(BotaniaFluffBlocks.biomeStoneFungal, BotaniaTags.Biomes.MARIMORPHOSIS_FUNGAL_BONUS));
		consumer.accept(biomeStone(BotaniaFluffBlocks.biomeStoneSwamp, BotaniaTags.Biomes.MARIMORPHOSIS_SWAMP_BONUS));
		consumer.accept(biomeStone(BotaniaFluffBlocks.biomeStoneDesert, BotaniaTags.Biomes.MARIMORPHOSIS_DESERT_BONUS));
		consumer.accept(biomeStone(BotaniaFluffBlocks.biomeStoneTaiga, BotaniaTags.Biomes.MARIMORPHOSIS_TAIGA_BONUS));
		consumer.accept(biomeStone(BotaniaFluffBlocks.biomeStoneMesa, BotaniaTags.Biomes.MARIMORPHOSIS_MESA_BONUS));
	}

	protected class_2960 orechidId(class_2248 b) {
		return prefix("orechid/" + class_2378.field_11146.method_10221(b).method_12832());
	}

	protected class_2960 ignemId(class_2248 b) {
		return prefix("orechid_ignem/" + class_2378.field_11146.method_10221(b).method_12832());
	}

	protected class_2960 marimorphosisId(class_2248 b) {
		return prefix("marimorphosis/" + class_2378.field_11146.method_10221(b).method_12832());
	}

	protected Result stone(class_2248 output, int weight) {
		return new Result(BotaniaRecipeTypes.ORECHID_SERIALIZER, orechidId(output),
				forBlock(class_2246.field_10340), forBlock(output), weight);
	}

	protected Result deepslate(class_2248 output, int weight) {
		return new Result(BotaniaRecipeTypes.ORECHID_SERIALIZER, orechidId(output),
				forBlock(class_2246.field_28888), forBlock(output), weight);
	}

	protected Result netherrack(class_2248 output, int weight) {
		return new Result(BotaniaRecipeTypes.ORECHID_IGNEM_SERIALIZER, ignemId(output),
				forBlock(class_2246.field_10515), forBlock(output), weight);
	}

	protected Result biomeStone(class_2248 output, class_6862<class_1959> biome) {
		return new BiomeResult(BotaniaRecipeTypes.MARIMORPHOSIS_SERIALIZER, marimorphosisId(output),
				forTag(BotaniaTags.Blocks.MARIMORPHOSIS_CONVERTABLE), forBlock(output), 1, 11, biome);
	}

	protected static StateIngredient forBlock(class_2248 block) {
		return StateIngredientHelper.of(block);
	}

	protected static StateIngredient forTag(class_6862<class_2248> tag) {
		return StateIngredientHelper.of(tag);
	}

	@Override
	public String method_10321() {
		return "Botania Orechid and Marimorphosis recipes";
	}

	protected static class Result implements net.minecraft.class_2444 {
		private final class_1865<? extends OrechidRecipe> type;
		private final class_2960 id;
		private final StateIngredient input;
		private final StateIngredient output;
		private final int weight;

		public Result(class_1865<? extends OrechidRecipe> type, class_2960 id,
				StateIngredient input, StateIngredient output, int weight) {
			this.type = type;
			this.id = id;
			this.input = input;
			this.output = output;
			this.weight = weight;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.add("input", input.serialize());
			json.add("output", output.serialize());
			json.addProperty("weight", weight);
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return type;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}

	protected static class BiomeResult extends Result {
		private final int bonusWeight;
		private final class_6862<class_1959> biome;

		public BiomeResult(class_1865<? extends OrechidRecipe> type, class_2960 id,
				StateIngredient input, StateIngredient output, int weight, int bonusWeight,
				class_6862<class_1959> biome) {
			super(type, id, input, output, weight);
			this.bonusWeight = bonusWeight;
			this.biome = biome;
		}

		@Override
		public void method_10416(JsonObject json) {
			super.method_10416(json);
			json.addProperty("biome_bonus_tag", biome.comp_327().toString());
			json.addProperty("biome_bonus", bonusWeight);
		}
	}

}
